/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingRequest;
import software.amazon.awssdk.services.medicalimaging.model.MetadataUpdates;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateImageSetMetadataRequest
extends MedicalImagingRequest
implements ToCopyableBuilder<Builder, UpdateImageSetMetadataRequest> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(UpdateImageSetMetadataRequest.getter(UpdateImageSetMetadataRequest::datastoreId)).setter(UpdateImageSetMetadataRequest.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreId").build()}).build();
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetId").getter(UpdateImageSetMetadataRequest.getter(UpdateImageSetMetadataRequest::imageSetId)).setter(UpdateImageSetMetadataRequest.setter(Builder::imageSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("imageSetId").build()}).build();
    private static final SdkField<String> LATEST_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestVersionId").getter(UpdateImageSetMetadataRequest.getter(UpdateImageSetMetadataRequest::latestVersionId)).setter(UpdateImageSetMetadataRequest.setter(Builder::latestVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("latestVersion").build()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("force").getter(UpdateImageSetMetadataRequest.getter(UpdateImageSetMetadataRequest::force)).setter(UpdateImageSetMetadataRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("force").build()}).build();
    private static final SdkField<MetadataUpdates> UPDATE_IMAGE_SET_METADATA_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updateImageSetMetadataUpdates").getter(UpdateImageSetMetadataRequest.getter(UpdateImageSetMetadataRequest::updateImageSetMetadataUpdates)).setter(UpdateImageSetMetadataRequest.setter(Builder::updateImageSetMetadataUpdates)).constructor(MetadataUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateImageSetMetadataUpdates").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, IMAGE_SET_ID_FIELD, LATEST_VERSION_ID_FIELD, FORCE_FIELD, UPDATE_IMAGE_SET_METADATA_UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateImageSetMetadataRequest.memberNameToFieldInitializer();
    private final String datastoreId;
    private final String imageSetId;
    private final String latestVersionId;
    private final Boolean force;
    private final MetadataUpdates updateImageSetMetadataUpdates;

    private UpdateImageSetMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.latestVersionId = builder.latestVersionId;
        this.force = builder.force;
        this.updateImageSetMetadataUpdates = builder.updateImageSetMetadataUpdates;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String imageSetId() {
        return this.imageSetId;
    }

    public final String latestVersionId() {
        return this.latestVersionId;
    }

    public final Boolean force() {
        return this.force;
    }

    public final MetadataUpdates updateImageSetMetadataUpdates() {
        return this.updateImageSetMetadataUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateImageSetMetadataUpdates());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageSetMetadataRequest)) {
            return false;
        }
        UpdateImageSetMetadataRequest other = (UpdateImageSetMetadataRequest)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.imageSetId(), other.imageSetId()) && Objects.equals(this.latestVersionId(), other.latestVersionId()) && Objects.equals(this.force(), other.force()) && Objects.equals(this.updateImageSetMetadataUpdates(), other.updateImageSetMetadataUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateImageSetMetadataRequest").add("DatastoreId", (Object)this.datastoreId()).add("ImageSetId", (Object)this.imageSetId()).add("LatestVersionId", (Object)this.latestVersionId()).add("Force", (Object)this.force()).add("UpdateImageSetMetadataUpdates", (Object)this.updateImageSetMetadataUpdates()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "imageSetId": {
                return Optional.ofNullable(clazz.cast(this.imageSetId()));
            }
            case "latestVersionId": {
                return Optional.ofNullable(clazz.cast(this.latestVersionId()));
            }
            case "force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
            case "updateImageSetMetadataUpdates": {
                return Optional.ofNullable(clazz.cast(this.updateImageSetMetadataUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datastoreId", DATASTORE_ID_FIELD);
        map.put("imageSetId", IMAGE_SET_ID_FIELD);
        map.put("latestVersion", LATEST_VERSION_ID_FIELD);
        map.put("force", FORCE_FIELD);
        map.put("updateImageSetMetadataUpdates", UPDATE_IMAGE_SET_METADATA_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageSetMetadataRequest, T> g) {
        return obj -> g.apply((UpdateImageSetMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingRequest.BuilderImpl
    implements Builder {
        private String datastoreId;
        private String imageSetId;
        private String latestVersionId;
        private Boolean force;
        private MetadataUpdates updateImageSetMetadataUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageSetMetadataRequest model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.imageSetId(model.imageSetId);
            this.latestVersionId(model.latestVersionId);
            this.force(model.force);
            this.updateImageSetMetadataUpdates(model.updateImageSetMetadataUpdates);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return this.imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getLatestVersionId() {
            return this.latestVersionId;
        }

        public final void setLatestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final Boolean getForce() {
            return this.force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final MetadataUpdates.Builder getUpdateImageSetMetadataUpdates() {
            return this.updateImageSetMetadataUpdates != null ? this.updateImageSetMetadataUpdates.toBuilder() : null;
        }

        public final void setUpdateImageSetMetadataUpdates(MetadataUpdates.BuilderImpl updateImageSetMetadataUpdates) {
            this.updateImageSetMetadataUpdates = updateImageSetMetadataUpdates != null ? updateImageSetMetadataUpdates.build() : null;
        }

        @Override
        public final Builder updateImageSetMetadataUpdates(MetadataUpdates updateImageSetMetadataUpdates) {
            this.updateImageSetMetadataUpdates = updateImageSetMetadataUpdates;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImageSetMetadataRequest build() {
            return new UpdateImageSetMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MedicalImagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateImageSetMetadataRequest> {
        public Builder datastoreId(String var1);

        public Builder imageSetId(String var1);

        public Builder latestVersionId(String var1);

        public Builder force(Boolean var1);

        public Builder updateImageSetMetadataUpdates(MetadataUpdates var1);

        default public Builder updateImageSetMetadataUpdates(Consumer<MetadataUpdates.Builder> updateImageSetMetadataUpdates) {
            return this.updateImageSetMetadataUpdates((MetadataUpdates)((MetadataUpdates.Builder)MetadataUpdates.builder().applyMutation(updateImageSetMetadataUpdates)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

