/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.DICOMTags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageSetsMetadataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageSetsMetadataSummary> {
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetId").getter(ImageSetsMetadataSummary.getter(ImageSetsMetadataSummary::imageSetId)).setter(ImageSetsMetadataSummary.setter(Builder::imageSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("version").getter(ImageSetsMetadataSummary.getter(ImageSetsMetadataSummary::version)).setter(ImageSetsMetadataSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ImageSetsMetadataSummary.getter(ImageSetsMetadataSummary::createdAt)).setter(ImageSetsMetadataSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ImageSetsMetadataSummary.getter(ImageSetsMetadataSummary::updatedAt)).setter(ImageSetsMetadataSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<DICOMTags> DICOM_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DICOMTags").getter(ImageSetsMetadataSummary.getter(ImageSetsMetadataSummary::dicomTags)).setter(ImageSetsMetadataSummary.setter(Builder::dicomTags)).constructor(DICOMTags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMTags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SET_ID_FIELD, VERSION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DICOM_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageSetsMetadataSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String imageSetId;
    private final Integer version;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final DICOMTags dicomTags;

    private ImageSetsMetadataSummary(BuilderImpl builder) {
        this.imageSetId = builder.imageSetId;
        this.version = builder.version;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.dicomTags = builder.dicomTags;
    }

    public final String imageSetId() {
        return this.imageSetId;
    }

    public final Integer version() {
        return this.version;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final DICOMTags dicomTags() {
        return this.dicomTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dicomTags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSetsMetadataSummary)) {
            return false;
        }
        ImageSetsMetadataSummary other = (ImageSetsMetadataSummary)obj;
        return Objects.equals(this.imageSetId(), other.imageSetId()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.dicomTags(), other.dicomTags());
    }

    public final String toString() {
        return ToString.builder((String)"ImageSetsMetadataSummary").add("ImageSetId", (Object)this.imageSetId()).add("Version", (Object)this.version()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("DICOMTags", (Object)this.dicomTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageSetId": {
                return Optional.ofNullable(clazz.cast(this.imageSetId()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "DICOMTags": {
                return Optional.ofNullable(clazz.cast(this.dicomTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imageSetId", IMAGE_SET_ID_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("DICOMTags", DICOM_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSetsMetadataSummary, T> g) {
        return obj -> g.apply((ImageSetsMetadataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageSetId;
        private Integer version;
        private Instant createdAt;
        private Instant updatedAt;
        private DICOMTags dicomTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSetsMetadataSummary model) {
            this.imageSetId(model.imageSetId);
            this.version(model.version);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.dicomTags(model.dicomTags);
        }

        public final String getImageSetId() {
            return this.imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final DICOMTags.Builder getDicomTags() {
            return this.dicomTags != null ? this.dicomTags.toBuilder() : null;
        }

        public final void setDicomTags(DICOMTags.BuilderImpl dicomTags) {
            this.dicomTags = dicomTags != null ? dicomTags.build() : null;
        }

        @Override
        public final Builder dicomTags(DICOMTags dicomTags) {
            this.dicomTags = dicomTags;
            return this;
        }

        public ImageSetsMetadataSummary build() {
            return new ImageSetsMetadataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageSetsMetadataSummary> {
        public Builder imageSetId(String var1);

        public Builder version(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder dicomTags(DICOMTags var1);

        default public Builder dicomTags(Consumer<DICOMTags.Builder> dicomTags) {
            return this.dicomTags((DICOMTags)((DICOMTags.Builder)DICOMTags.builder().applyMutation(dicomTags)).build());
        }
    }
}

