/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetProperties;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetPropertiesListCopier;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImageSetVersionsResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, ListImageSetVersionsResponse> {
    private static final SdkField<List<ImageSetProperties>> IMAGE_SET_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageSetPropertiesList").getter(ListImageSetVersionsResponse.getter(ListImageSetVersionsResponse::imageSetPropertiesList)).setter(ListImageSetVersionsResponse.setter(Builder::imageSetPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageSetProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImageSetVersionsResponse.getter(ListImageSetVersionsResponse::nextToken)).setter(ListImageSetVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SET_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListImageSetVersionsResponse.memberNameToFieldInitializer();
    private final List<ImageSetProperties> imageSetPropertiesList;
    private final String nextToken;

    private ListImageSetVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.imageSetPropertiesList = builder.imageSetPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImageSetPropertiesList() {
        return this.imageSetPropertiesList != null && !(this.imageSetPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<ImageSetProperties> imageSetPropertiesList() {
        return this.imageSetPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageSetPropertiesList() ? this.imageSetPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageSetVersionsResponse)) {
            return false;
        }
        ListImageSetVersionsResponse other = (ListImageSetVersionsResponse)((Object)obj);
        return this.hasImageSetPropertiesList() == other.hasImageSetPropertiesList() && Objects.equals(this.imageSetPropertiesList(), other.imageSetPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImageSetVersionsResponse").add("ImageSetPropertiesList", this.hasImageSetPropertiesList() ? this.imageSetPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageSetPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.imageSetPropertiesList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("imageSetPropertiesList", IMAGE_SET_PROPERTIES_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImageSetVersionsResponse, T> g) {
        return obj -> g.apply((ListImageSetVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private List<ImageSetProperties> imageSetPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageSetVersionsResponse model) {
            super(model);
            this.imageSetPropertiesList(model.imageSetPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<ImageSetProperties.Builder> getImageSetPropertiesList() {
            List<ImageSetProperties.Builder> result = ImageSetPropertiesListCopier.copyToBuilder(this.imageSetPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageSetPropertiesList(Collection<ImageSetProperties.BuilderImpl> imageSetPropertiesList) {
            this.imageSetPropertiesList = ImageSetPropertiesListCopier.copyFromBuilder(imageSetPropertiesList);
        }

        @Override
        public final Builder imageSetPropertiesList(Collection<ImageSetProperties> imageSetPropertiesList) {
            this.imageSetPropertiesList = ImageSetPropertiesListCopier.copy(imageSetPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSetPropertiesList(ImageSetProperties ... imageSetPropertiesList) {
            this.imageSetPropertiesList(Arrays.asList(imageSetPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSetPropertiesList(Consumer<ImageSetProperties.Builder> ... imageSetPropertiesList) {
            this.imageSetPropertiesList(Stream.of(imageSetPropertiesList).map(c -> (ImageSetProperties)((ImageSetProperties.Builder)ImageSetProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImageSetVersionsResponse build() {
            return new ListImageSetVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImageSetVersionsResponse> {
        public Builder imageSetPropertiesList(Collection<ImageSetProperties> var1);

        public Builder imageSetPropertiesList(ImageSetProperties ... var1);

        public Builder imageSetPropertiesList(Consumer<ImageSetProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

