/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingAsyncClient;
import software.amazon.awssdk.services.medicalimaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.medicalimaging.model.DatastoreSummary;
import software.amazon.awssdk.services.medicalimaging.model.ListDatastoresRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListDatastoresResponse;

public class ListDatastoresPublisher
implements SdkPublisher<ListDatastoresResponse> {
    private final MedicalImagingAsyncClient client;
    private final ListDatastoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatastoresPublisher(MedicalImagingAsyncClient client, ListDatastoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatastoresPublisher(MedicalImagingAsyncClient client, ListDatastoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatastoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatastoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DatastoreSummary> datastoreSummaries() {
        Function<ListDatastoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.datastoreSummaries() != null) {
                return response.datastoreSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatastoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatastoresResponseFetcher
    implements AsyncPageFetcher<ListDatastoresResponse> {
        private ListDatastoresResponseFetcher() {
        }

        public boolean hasNextPage(ListDatastoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatastoresResponse> nextPage(ListDatastoresResponse previousPage) {
            if (previousPage == null) {
                return ListDatastoresPublisher.this.client.listDatastores(ListDatastoresPublisher.this.firstRequest);
            }
            return ListDatastoresPublisher.this.client.listDatastores((ListDatastoresRequest)((Object)ListDatastoresPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

