/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingAsyncClient;
import software.amazon.awssdk.services.medicalimaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetsMetadataSummary;
import software.amazon.awssdk.services.medicalimaging.model.SearchImageSetsRequest;
import software.amazon.awssdk.services.medicalimaging.model.SearchImageSetsResponse;

public class SearchImageSetsPublisher
implements SdkPublisher<SearchImageSetsResponse> {
    private final MedicalImagingAsyncClient client;
    private final SearchImageSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchImageSetsPublisher(MedicalImagingAsyncClient client, SearchImageSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchImageSetsPublisher(MedicalImagingAsyncClient client, SearchImageSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchImageSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchImageSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageSetsMetadataSummary> imageSetsMetadataSummaries() {
        Function<SearchImageSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageSetsMetadataSummaries() != null) {
                return response.imageSetsMetadataSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchImageSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchImageSetsResponseFetcher
    implements AsyncPageFetcher<SearchImageSetsResponse> {
        private SearchImageSetsResponseFetcher() {
        }

        public boolean hasNextPage(SearchImageSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchImageSetsResponse> nextPage(SearchImageSetsResponse previousPage) {
            if (previousPage == null) {
                return SearchImageSetsPublisher.this.client.searchImageSets(SearchImageSetsPublisher.this.firstRequest);
            }
            return SearchImageSetsPublisher.this.client.searchImageSets((SearchImageSetsRequest)((Object)SearchImageSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

