/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetState;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetWorkflowStatus;
import software.amazon.awssdk.services.medicalimaging.model.Overrides;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageSetProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageSetProperties> {
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetId").getter(ImageSetProperties.getter(ImageSetProperties::imageSetId)).setter(ImageSetProperties.setter(Builder::imageSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionId").getter(ImageSetProperties.getter(ImageSetProperties::versionId)).setter(ImageSetProperties.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()}).build();
    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetState").getter(ImageSetProperties.getter(ImageSetProperties::imageSetStateAsString)).setter(ImageSetProperties.setter(Builder::imageSetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()}).build();
    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageSetWorkflowStatus").getter(ImageSetProperties.getter(ImageSetProperties::imageSetWorkflowStatusAsString)).setter(ImageSetProperties.setter(Builder::imageSetWorkflowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSetWorkflowStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ImageSetProperties.getter(ImageSetProperties::createdAt)).setter(ImageSetProperties.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ImageSetProperties.getter(ImageSetProperties::updatedAt)).setter(ImageSetProperties.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("deletedAt").getter(ImageSetProperties.getter(ImageSetProperties::deletedAt)).setter(ImageSetProperties.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedAt").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(ImageSetProperties.getter(ImageSetProperties::message)).setter(ImageSetProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Overrides> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrides").getter(ImageSetProperties.getter(ImageSetProperties::overrides)).setter(ImageSetProperties.setter(Builder::overrides)).constructor(Overrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SET_ID_FIELD, VERSION_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DELETED_AT_FIELD, MESSAGE_FIELD, OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("imageSetId", IMAGE_SET_ID_FIELD);
            this.put("versionId", VERSION_ID_FIELD);
            this.put("imageSetState", IMAGE_SET_STATE_FIELD);
            this.put("ImageSetWorkflowStatus", IMAGE_SET_WORKFLOW_STATUS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("deletedAt", DELETED_AT_FIELD);
            this.put("message", MESSAGE_FIELD);
            this.put("overrides", OVERRIDES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String imageSetId;
    private final String versionId;
    private final String imageSetState;
    private final String imageSetWorkflowStatus;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Instant deletedAt;
    private final String message;
    private final Overrides overrides;

    private ImageSetProperties(BuilderImpl builder) {
        this.imageSetId = builder.imageSetId;
        this.versionId = builder.versionId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.deletedAt = builder.deletedAt;
        this.message = builder.message;
        this.overrides = builder.overrides;
    }

    public final String imageSetId() {
        return this.imageSetId;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(this.imageSetState);
    }

    public final String imageSetStateAsString() {
        return this.imageSetState;
    }

    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(this.imageSetWorkflowStatus);
    }

    public final String imageSetWorkflowStatusAsString() {
        return this.imageSetWorkflowStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public final String message() {
        return this.message;
    }

    public final Overrides overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetWorkflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSetProperties)) {
            return false;
        }
        ImageSetProperties other = (ImageSetProperties)obj;
        return Objects.equals(this.imageSetId(), other.imageSetId()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.imageSetStateAsString(), other.imageSetStateAsString()) && Objects.equals(this.imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.deletedAt(), other.deletedAt()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.overrides(), other.overrides());
    }

    public final String toString() {
        return ToString.builder((String)"ImageSetProperties").add("ImageSetId", (Object)this.imageSetId()).add("VersionId", (Object)this.versionId()).add("ImageSetState", (Object)this.imageSetStateAsString()).add("ImageSetWorkflowStatus", (Object)this.imageSetWorkflowStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("DeletedAt", (Object)this.deletedAt()).add("Message", (Object)this.message()).add("Overrides", (Object)this.overrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageSetId": {
                return Optional.ofNullable(clazz.cast(this.imageSetId()));
            }
            case "versionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "imageSetState": {
                return Optional.ofNullable(clazz.cast(this.imageSetStateAsString()));
            }
            case "ImageSetWorkflowStatus": {
                return Optional.ofNullable(clazz.cast(this.imageSetWorkflowStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "deletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImageSetProperties, T> g) {
        return obj -> g.apply((ImageSetProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageSetId;
        private String versionId;
        private String imageSetState;
        private String imageSetWorkflowStatus;
        private Instant createdAt;
        private Instant updatedAt;
        private Instant deletedAt;
        private String message;
        private Overrides overrides;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSetProperties model) {
            this.imageSetId(model.imageSetId);
            this.versionId(model.versionId);
            this.imageSetState(model.imageSetState);
            this.imageSetWorkflowStatus(model.imageSetWorkflowStatus);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.deletedAt(model.deletedAt);
            this.message(model.message);
            this.overrides(model.overrides);
        }

        public final String getImageSetId() {
            return this.imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getImageSetState() {
            return this.imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return this.imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Overrides.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        public final void setOverrides(Overrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(Overrides overrides) {
            this.overrides = overrides;
            return this;
        }

        public ImageSetProperties build() {
            return new ImageSetProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageSetProperties> {
        public Builder imageSetId(String var1);

        public Builder versionId(String var1);

        public Builder imageSetState(String var1);

        public Builder imageSetState(ImageSetState var1);

        public Builder imageSetWorkflowStatus(String var1);

        public Builder imageSetWorkflowStatus(ImageSetWorkflowStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder deletedAt(Instant var1);

        public Builder message(String var1);

        public Builder overrides(Overrides var1);

        default public Builder overrides(Consumer<Overrides.Builder> overrides) {
            return this.overrides((Overrides)((Overrides.Builder)Overrides.builder().applyMutation(overrides)).build());
        }
    }
}

