/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetState;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetWorkflowStatus;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteImageSetResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, DeleteImageSetResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(DeleteImageSetResponse.getter(DeleteImageSetResponse::datastoreId)).setter(DeleteImageSetResponse.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()}).build();
    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetId").getter(DeleteImageSetResponse.getter(DeleteImageSetResponse::imageSetId)).setter(DeleteImageSetResponse.setter(Builder::imageSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()}).build();
    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetState").getter(DeleteImageSetResponse.getter(DeleteImageSetResponse::imageSetStateAsString)).setter(DeleteImageSetResponse.setter(Builder::imageSetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()}).build();
    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSetWorkflowStatus").getter(DeleteImageSetResponse.getter(DeleteImageSetResponse::imageSetWorkflowStatusAsString)).setter(DeleteImageSetResponse.setter(Builder::imageSetWorkflowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetWorkflowStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, IMAGE_SET_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datastoreId", DATASTORE_ID_FIELD);
            this.put("imageSetId", IMAGE_SET_ID_FIELD);
            this.put("imageSetState", IMAGE_SET_STATE_FIELD);
            this.put("imageSetWorkflowStatus", IMAGE_SET_WORKFLOW_STATUS_FIELD);
        }
    });
    private final String datastoreId;
    private final String imageSetId;
    private final String imageSetState;
    private final String imageSetWorkflowStatus;

    private DeleteImageSetResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String imageSetId() {
        return this.imageSetId;
    }

    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(this.imageSetState);
    }

    public final String imageSetStateAsString() {
        return this.imageSetState;
    }

    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(this.imageSetWorkflowStatus);
    }

    public final String imageSetWorkflowStatusAsString() {
        return this.imageSetWorkflowStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSetWorkflowStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImageSetResponse)) {
            return false;
        }
        DeleteImageSetResponse other = (DeleteImageSetResponse)((Object)obj);
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.imageSetId(), other.imageSetId()) && Objects.equals(this.imageSetStateAsString(), other.imageSetStateAsString()) && Objects.equals(this.imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteImageSetResponse").add("DatastoreId", (Object)this.datastoreId()).add("ImageSetId", (Object)this.imageSetId()).add("ImageSetState", (Object)this.imageSetStateAsString()).add("ImageSetWorkflowStatus", (Object)this.imageSetWorkflowStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "imageSetId": {
                return Optional.ofNullable(clazz.cast(this.imageSetId()));
            }
            case "imageSetState": {
                return Optional.ofNullable(clazz.cast(this.imageSetStateAsString()));
            }
            case "imageSetWorkflowStatus": {
                return Optional.ofNullable(clazz.cast(this.imageSetWorkflowStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteImageSetResponse, T> g) {
        return obj -> g.apply((DeleteImageSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private String datastoreId;
        private String imageSetId;
        private String imageSetState;
        private String imageSetWorkflowStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImageSetResponse model) {
            super(model);
            this.datastoreId(model.datastoreId);
            this.imageSetId(model.imageSetId);
            this.imageSetState(model.imageSetState);
            this.imageSetWorkflowStatus(model.imageSetWorkflowStatus);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return this.imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getImageSetState() {
            return this.imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return this.imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        @Override
        public DeleteImageSetResponse build() {
            return new DeleteImageSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteImageSetResponse> {
        public Builder datastoreId(String var1);

        public Builder imageSetId(String var1);

        public Builder imageSetState(String var1);

        public Builder imageSetState(ImageSetState var1);

        public Builder imageSetWorkflowStatus(String var1);

        public Builder imageSetWorkflowStatus(ImageSetWorkflowStatus var1);
    }
}

