/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SortField {
    UPDATED_AT("updatedAt"),
    CREATED_AT("createdAt"),
    DICOM_STUDY_DATE_AND_TIME("DICOMStudyDateAndTime"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SortField> VALUE_MAP;
    private final String value;

    private SortField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SortField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SortField> knownValues() {
        EnumSet<SortField> knownValues = EnumSet.allOf(SortField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SortField.class, SortField::toString);
    }
}

