/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDicomImportJobRequest
extends MedicalImagingRequest
implements ToCopyableBuilder<Builder, StartDicomImportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(StartDicomImportJobRequest.getter(StartDicomImportJobRequest::jobName)).setter(StartDicomImportJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAccessRoleArn").getter(StartDicomImportJobRequest.getter(StartDicomImportJobRequest::dataAccessRoleArn)).setter(StartDicomImportJobRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRoleArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartDicomImportJobRequest.getter(StartDicomImportJobRequest::clientToken)).setter(StartDicomImportJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(StartDicomImportJobRequest.getter(StartDicomImportJobRequest::datastoreId)).setter(StartDicomImportJobRequest.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreId").build()}).build();
    private static final SdkField<String> INPUT_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputS3Uri").getter(StartDicomImportJobRequest.getter(StartDicomImportJobRequest::inputS3Uri)).setter(StartDicomImportJobRequest.setter(Builder::inputS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputS3Uri").build()}).build();
    private static final SdkField<String> OUTPUT_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3Uri").getter(StartDicomImportJobRequest.getter(StartDicomImportJobRequest::outputS3Uri)).setter(StartDicomImportJobRequest.setter(Builder::outputS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Uri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, DATASTORE_ID_FIELD, INPUT_S3_URI_FIELD, OUTPUT_S3_URI_FIELD));
    private final String jobName;
    private final String dataAccessRoleArn;
    private final String clientToken;
    private final String datastoreId;
    private final String inputS3Uri;
    private final String outputS3Uri;

    private StartDicomImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.clientToken = builder.clientToken;
        this.datastoreId = builder.datastoreId;
        this.inputS3Uri = builder.inputS3Uri;
        this.outputS3Uri = builder.outputS3Uri;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String inputS3Uri() {
        return this.inputS3Uri;
    }

    public final String outputS3Uri() {
        return this.outputS3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Uri());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDicomImportJobRequest)) {
            return false;
        }
        StartDicomImportJobRequest other = (StartDicomImportJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.inputS3Uri(), other.inputS3Uri()) && Objects.equals(this.outputS3Uri(), other.outputS3Uri());
    }

    public final String toString() {
        return ToString.builder((String)"StartDicomImportJobRequest").add("JobName", (Object)this.jobName()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("ClientToken", (Object)this.clientToken()).add("DatastoreId", (Object)this.datastoreId()).add("InputS3Uri", (Object)this.inputS3Uri()).add("OutputS3Uri", (Object)this.outputS3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "dataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "inputS3Uri": {
                return Optional.ofNullable(clazz.cast(this.inputS3Uri()));
            }
            case "outputS3Uri": {
                return Optional.ofNullable(clazz.cast(this.outputS3Uri()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDicomImportJobRequest, T> g) {
        return obj -> g.apply((StartDicomImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String dataAccessRoleArn;
        private String clientToken;
        private String datastoreId;
        private String inputS3Uri;
        private String outputS3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDicomImportJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.clientToken(model.clientToken);
            this.datastoreId(model.datastoreId);
            this.inputS3Uri(model.inputS3Uri);
            this.outputS3Uri(model.outputS3Uri);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getInputS3Uri() {
            return this.inputS3Uri;
        }

        public final void setInputS3Uri(String inputS3Uri) {
            this.inputS3Uri = inputS3Uri;
        }

        @Override
        public final Builder inputS3Uri(String inputS3Uri) {
            this.inputS3Uri = inputS3Uri;
            return this;
        }

        public final String getOutputS3Uri() {
            return this.outputS3Uri;
        }

        public final void setOutputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
        }

        @Override
        public final Builder outputS3Uri(String outputS3Uri) {
            this.outputS3Uri = outputS3Uri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDicomImportJobRequest build() {
            return new StartDicomImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MedicalImagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDicomImportJobRequest> {
        public Builder jobName(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder clientToken(String var1);

        public Builder datastoreId(String var1);

        public Builder inputS3Uri(String var1);

        public Builder outputS3Uri(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

