/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetsMetadataSummariesCopier;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetsMetadataSummary;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchImageSetsResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, SearchImageSetsResponse> {
    private static final SdkField<List<ImageSetsMetadataSummary>> IMAGE_SETS_METADATA_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageSetsMetadataSummaries").getter(SearchImageSetsResponse.getter(SearchImageSetsResponse::imageSetsMetadataSummaries)).setter(SearchImageSetsResponse.setter(Builder::imageSetsMetadataSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetsMetadataSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageSetsMetadataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchImageSetsResponse.getter(SearchImageSetsResponse::nextToken)).setter(SearchImageSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SETS_METADATA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ImageSetsMetadataSummary> imageSetsMetadataSummaries;
    private final String nextToken;

    private SearchImageSetsResponse(BuilderImpl builder) {
        super(builder);
        this.imageSetsMetadataSummaries = builder.imageSetsMetadataSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImageSetsMetadataSummaries() {
        return this.imageSetsMetadataSummaries != null && !(this.imageSetsMetadataSummaries instanceof SdkAutoConstructList);
    }

    public final List<ImageSetsMetadataSummary> imageSetsMetadataSummaries() {
        return this.imageSetsMetadataSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageSetsMetadataSummaries() ? this.imageSetsMetadataSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchImageSetsResponse)) {
            return false;
        }
        SearchImageSetsResponse other = (SearchImageSetsResponse)((Object)obj);
        return this.hasImageSetsMetadataSummaries() == other.hasImageSetsMetadataSummaries() && Objects.equals(this.imageSetsMetadataSummaries(), other.imageSetsMetadataSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchImageSetsResponse").add("ImageSetsMetadataSummaries", this.hasImageSetsMetadataSummaries() ? this.imageSetsMetadataSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageSetsMetadataSummaries": {
                return Optional.ofNullable(clazz.cast(this.imageSetsMetadataSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchImageSetsResponse, T> g) {
        return obj -> g.apply((SearchImageSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private List<ImageSetsMetadataSummary> imageSetsMetadataSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchImageSetsResponse model) {
            super(model);
            this.imageSetsMetadataSummaries(model.imageSetsMetadataSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ImageSetsMetadataSummary.Builder> getImageSetsMetadataSummaries() {
            List<ImageSetsMetadataSummary.Builder> result = ImageSetsMetadataSummariesCopier.copyToBuilder(this.imageSetsMetadataSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageSetsMetadataSummaries(Collection<ImageSetsMetadataSummary.BuilderImpl> imageSetsMetadataSummaries) {
            this.imageSetsMetadataSummaries = ImageSetsMetadataSummariesCopier.copyFromBuilder(imageSetsMetadataSummaries);
        }

        @Override
        public final Builder imageSetsMetadataSummaries(Collection<ImageSetsMetadataSummary> imageSetsMetadataSummaries) {
            this.imageSetsMetadataSummaries = ImageSetsMetadataSummariesCopier.copy(imageSetsMetadataSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSetsMetadataSummaries(ImageSetsMetadataSummary ... imageSetsMetadataSummaries) {
            this.imageSetsMetadataSummaries(Arrays.asList(imageSetsMetadataSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSetsMetadataSummaries(Consumer<ImageSetsMetadataSummary.Builder> ... imageSetsMetadataSummaries) {
            this.imageSetsMetadataSummaries(Stream.of(imageSetsMetadataSummaries).map(c -> (ImageSetsMetadataSummary)((ImageSetsMetadataSummary.Builder)ImageSetsMetadataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchImageSetsResponse build() {
            return new SearchImageSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchImageSetsResponse> {
        public Builder imageSetsMetadataSummaries(Collection<ImageSetsMetadataSummary> var1);

        public Builder imageSetsMetadataSummaries(ImageSetsMetadataSummary ... var1);

        public Builder imageSetsMetadataSummaries(Consumer<ImageSetsMetadataSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

