/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medicalimaging.model.DICOMStudyDateAndTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchByAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchByAttributeValue> {
    private static final SdkField<String> DICOM_PATIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DICOMPatientId").getter(SearchByAttributeValue.getter(SearchByAttributeValue::dicomPatientId)).setter(SearchByAttributeValue.setter(Builder::dicomPatientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMPatientId").build()}).build();
    private static final SdkField<String> DICOM_ACCESSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DICOMAccessionNumber").getter(SearchByAttributeValue.getter(SearchByAttributeValue::dicomAccessionNumber)).setter(SearchByAttributeValue.setter(Builder::dicomAccessionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMAccessionNumber").build()}).build();
    private static final SdkField<String> DICOM_STUDY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DICOMStudyId").getter(SearchByAttributeValue.getter(SearchByAttributeValue::dicomStudyId)).setter(SearchByAttributeValue.setter(Builder::dicomStudyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyId").build()}).build();
    private static final SdkField<String> DICOM_STUDY_INSTANCE_UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DICOMStudyInstanceUID").getter(SearchByAttributeValue.getter(SearchByAttributeValue::dicomStudyInstanceUID)).setter(SearchByAttributeValue.setter(Builder::dicomStudyInstanceUID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyInstanceUID").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SearchByAttributeValue.getter(SearchByAttributeValue::createdAt)).setter(SearchByAttributeValue.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<DICOMStudyDateAndTime> DICOM_STUDY_DATE_AND_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DICOMStudyDateAndTime").getter(SearchByAttributeValue.getter(SearchByAttributeValue::dicomStudyDateAndTime)).setter(SearchByAttributeValue.setter(Builder::dicomStudyDateAndTime)).constructor(DICOMStudyDateAndTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyDateAndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DICOM_PATIENT_ID_FIELD, DICOM_ACCESSION_NUMBER_FIELD, DICOM_STUDY_ID_FIELD, DICOM_STUDY_INSTANCE_UID_FIELD, CREATED_AT_FIELD, DICOM_STUDY_DATE_AND_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dicomPatientId;
    private final String dicomAccessionNumber;
    private final String dicomStudyId;
    private final String dicomStudyInstanceUID;
    private final Instant createdAt;
    private final DICOMStudyDateAndTime dicomStudyDateAndTime;
    private final Type type;

    private SearchByAttributeValue(BuilderImpl builder) {
        this.dicomPatientId = builder.dicomPatientId;
        this.dicomAccessionNumber = builder.dicomAccessionNumber;
        this.dicomStudyId = builder.dicomStudyId;
        this.dicomStudyInstanceUID = builder.dicomStudyInstanceUID;
        this.createdAt = builder.createdAt;
        this.dicomStudyDateAndTime = builder.dicomStudyDateAndTime;
        this.type = builder.type;
    }

    public final String dicomPatientId() {
        return this.dicomPatientId;
    }

    public final String dicomAccessionNumber() {
        return this.dicomAccessionNumber;
    }

    public final String dicomStudyId() {
        return this.dicomStudyId;
    }

    public final String dicomStudyInstanceUID() {
        return this.dicomStudyInstanceUID;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DICOMStudyDateAndTime dicomStudyDateAndTime() {
        return this.dicomStudyDateAndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dicomPatientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dicomAccessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.dicomStudyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dicomStudyInstanceUID());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dicomStudyDateAndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchByAttributeValue)) {
            return false;
        }
        SearchByAttributeValue other = (SearchByAttributeValue)obj;
        return Objects.equals(this.dicomPatientId(), other.dicomPatientId()) && Objects.equals(this.dicomAccessionNumber(), other.dicomAccessionNumber()) && Objects.equals(this.dicomStudyId(), other.dicomStudyId()) && Objects.equals(this.dicomStudyInstanceUID(), other.dicomStudyInstanceUID()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dicomStudyDateAndTime(), other.dicomStudyDateAndTime());
    }

    public final String toString() {
        return ToString.builder((String)"SearchByAttributeValue").add("DICOMPatientId", (Object)(this.dicomPatientId() == null ? null : "*** Sensitive Data Redacted ***")).add("DICOMAccessionNumber", (Object)(this.dicomAccessionNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("DICOMStudyId", (Object)(this.dicomStudyId() == null ? null : "*** Sensitive Data Redacted ***")).add("DICOMStudyInstanceUID", (Object)(this.dicomStudyInstanceUID() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("DICOMStudyDateAndTime", (Object)this.dicomStudyDateAndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DICOMPatientId": {
                return Optional.ofNullable(clazz.cast(this.dicomPatientId()));
            }
            case "DICOMAccessionNumber": {
                return Optional.ofNullable(clazz.cast(this.dicomAccessionNumber()));
            }
            case "DICOMStudyId": {
                return Optional.ofNullable(clazz.cast(this.dicomStudyId()));
            }
            case "DICOMStudyInstanceUID": {
                return Optional.ofNullable(clazz.cast(this.dicomStudyInstanceUID()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DICOMStudyDateAndTime": {
                return Optional.ofNullable(clazz.cast(this.dicomStudyDateAndTime()));
            }
        }
        return Optional.empty();
    }

    public static SearchByAttributeValue fromDicomPatientId(String dicomPatientId) {
        return (SearchByAttributeValue)SearchByAttributeValue.builder().dicomPatientId(dicomPatientId).build();
    }

    public static SearchByAttributeValue fromDicomAccessionNumber(String dicomAccessionNumber) {
        return (SearchByAttributeValue)SearchByAttributeValue.builder().dicomAccessionNumber(dicomAccessionNumber).build();
    }

    public static SearchByAttributeValue fromDicomStudyId(String dicomStudyId) {
        return (SearchByAttributeValue)SearchByAttributeValue.builder().dicomStudyId(dicomStudyId).build();
    }

    public static SearchByAttributeValue fromDicomStudyInstanceUID(String dicomStudyInstanceUID) {
        return (SearchByAttributeValue)SearchByAttributeValue.builder().dicomStudyInstanceUID(dicomStudyInstanceUID).build();
    }

    public static SearchByAttributeValue fromCreatedAt(Instant createdAt) {
        return (SearchByAttributeValue)SearchByAttributeValue.builder().createdAt(createdAt).build();
    }

    public static SearchByAttributeValue fromDicomStudyDateAndTime(DICOMStudyDateAndTime dicomStudyDateAndTime) {
        return (SearchByAttributeValue)SearchByAttributeValue.builder().dicomStudyDateAndTime(dicomStudyDateAndTime).build();
    }

    public static SearchByAttributeValue fromDicomStudyDateAndTime(Consumer<DICOMStudyDateAndTime.Builder> dicomStudyDateAndTime) {
        DICOMStudyDateAndTime.Builder builder = DICOMStudyDateAndTime.builder();
        dicomStudyDateAndTime.accept(builder);
        return SearchByAttributeValue.fromDicomStudyDateAndTime((DICOMStudyDateAndTime)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchByAttributeValue, T> g) {
        return obj -> g.apply((SearchByAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DICOM_PATIENT_ID,
        DICOM_ACCESSION_NUMBER,
        DICOM_STUDY_ID,
        DICOM_STUDY_INSTANCE_UID,
        CREATED_AT,
        DICOM_STUDY_DATE_AND_TIME,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String dicomPatientId;
        private String dicomAccessionNumber;
        private String dicomStudyId;
        private String dicomStudyInstanceUID;
        private Instant createdAt;
        private DICOMStudyDateAndTime dicomStudyDateAndTime;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchByAttributeValue model) {
            this.dicomPatientId(model.dicomPatientId);
            this.dicomAccessionNumber(model.dicomAccessionNumber);
            this.dicomStudyId(model.dicomStudyId);
            this.dicomStudyInstanceUID(model.dicomStudyInstanceUID);
            this.createdAt(model.createdAt);
            this.dicomStudyDateAndTime(model.dicomStudyDateAndTime);
        }

        public final String getDicomPatientId() {
            return this.dicomPatientId;
        }

        public final void setDicomPatientId(String dicomPatientId) {
            String oldValue = this.dicomPatientId;
            this.dicomPatientId = dicomPatientId;
            this.handleUnionValueChange(Type.DICOM_PATIENT_ID, oldValue, this.dicomPatientId);
        }

        @Override
        public final Builder dicomPatientId(String dicomPatientId) {
            String oldValue = this.dicomPatientId;
            this.dicomPatientId = dicomPatientId;
            this.handleUnionValueChange(Type.DICOM_PATIENT_ID, oldValue, this.dicomPatientId);
            return this;
        }

        public final String getDicomAccessionNumber() {
            return this.dicomAccessionNumber;
        }

        public final void setDicomAccessionNumber(String dicomAccessionNumber) {
            String oldValue = this.dicomAccessionNumber;
            this.dicomAccessionNumber = dicomAccessionNumber;
            this.handleUnionValueChange(Type.DICOM_ACCESSION_NUMBER, oldValue, this.dicomAccessionNumber);
        }

        @Override
        public final Builder dicomAccessionNumber(String dicomAccessionNumber) {
            String oldValue = this.dicomAccessionNumber;
            this.dicomAccessionNumber = dicomAccessionNumber;
            this.handleUnionValueChange(Type.DICOM_ACCESSION_NUMBER, oldValue, this.dicomAccessionNumber);
            return this;
        }

        public final String getDicomStudyId() {
            return this.dicomStudyId;
        }

        public final void setDicomStudyId(String dicomStudyId) {
            String oldValue = this.dicomStudyId;
            this.dicomStudyId = dicomStudyId;
            this.handleUnionValueChange(Type.DICOM_STUDY_ID, oldValue, this.dicomStudyId);
        }

        @Override
        public final Builder dicomStudyId(String dicomStudyId) {
            String oldValue = this.dicomStudyId;
            this.dicomStudyId = dicomStudyId;
            this.handleUnionValueChange(Type.DICOM_STUDY_ID, oldValue, this.dicomStudyId);
            return this;
        }

        public final String getDicomStudyInstanceUID() {
            return this.dicomStudyInstanceUID;
        }

        public final void setDicomStudyInstanceUID(String dicomStudyInstanceUID) {
            String oldValue = this.dicomStudyInstanceUID;
            this.dicomStudyInstanceUID = dicomStudyInstanceUID;
            this.handleUnionValueChange(Type.DICOM_STUDY_INSTANCE_UID, oldValue, this.dicomStudyInstanceUID);
        }

        @Override
        public final Builder dicomStudyInstanceUID(String dicomStudyInstanceUID) {
            String oldValue = this.dicomStudyInstanceUID;
            this.dicomStudyInstanceUID = dicomStudyInstanceUID;
            this.handleUnionValueChange(Type.DICOM_STUDY_INSTANCE_UID, oldValue, this.dicomStudyInstanceUID);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            Instant oldValue = this.createdAt;
            this.createdAt = createdAt;
            this.handleUnionValueChange(Type.CREATED_AT, oldValue, this.createdAt);
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            Instant oldValue = this.createdAt;
            this.createdAt = createdAt;
            this.handleUnionValueChange(Type.CREATED_AT, oldValue, this.createdAt);
            return this;
        }

        public final DICOMStudyDateAndTime.Builder getDicomStudyDateAndTime() {
            return this.dicomStudyDateAndTime != null ? this.dicomStudyDateAndTime.toBuilder() : null;
        }

        public final void setDicomStudyDateAndTime(DICOMStudyDateAndTime.BuilderImpl dicomStudyDateAndTime) {
            DICOMStudyDateAndTime oldValue = this.dicomStudyDateAndTime;
            this.dicomStudyDateAndTime = dicomStudyDateAndTime != null ? dicomStudyDateAndTime.build() : null;
            this.handleUnionValueChange(Type.DICOM_STUDY_DATE_AND_TIME, oldValue, this.dicomStudyDateAndTime);
        }

        @Override
        public final Builder dicomStudyDateAndTime(DICOMStudyDateAndTime dicomStudyDateAndTime) {
            DICOMStudyDateAndTime oldValue = this.dicomStudyDateAndTime;
            this.dicomStudyDateAndTime = dicomStudyDateAndTime;
            this.handleUnionValueChange(Type.DICOM_STUDY_DATE_AND_TIME, oldValue, this.dicomStudyDateAndTime);
            return this;
        }

        public SearchByAttributeValue build() {
            return new SearchByAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchByAttributeValue> {
        public Builder dicomPatientId(String var1);

        public Builder dicomAccessionNumber(String var1);

        public Builder dicomStudyId(String var1);

        public Builder dicomStudyInstanceUID(String var1);

        public Builder createdAt(Instant var1);

        public Builder dicomStudyDateAndTime(DICOMStudyDateAndTime var1);

        default public Builder dicomStudyDateAndTime(Consumer<DICOMStudyDateAndTime.Builder> dicomStudyDateAndTime) {
            return this.dicomStudyDateAndTime((DICOMStudyDateAndTime)((DICOMStudyDateAndTime.Builder)DICOMStudyDateAndTime.builder().applyMutation(dicomStudyDateAndTime)).build());
        }
    }
}

