/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.CompressionMethod;
import software.amazon.awssdk.services.mediatailor.model.Method;
import software.amazon.awssdk.services.mediatailor.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpRequest> {
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Method").getter(HttpRequest.getter(HttpRequest::methodAsString)).setter(HttpRequest.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(HttpRequest.getter(HttpRequest::body)).setter(HttpRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Headers").getter(HttpRequest.getter(HttpRequest::headers)).setter(HttpRequest.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> COMPRESS_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressRequest").getter(HttpRequest.getter(HttpRequest::compressRequestAsString)).setter(HttpRequest.setter(Builder::compressRequest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METHOD_FIELD, BODY_FIELD, HEADERS_FIELD, COMPRESS_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HttpRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String method;
    private final String body;
    private final Map<String, String> headers;
    private final String compressRequest;

    private HttpRequest(BuilderImpl builder) {
        this.method = builder.method;
        this.body = builder.body;
        this.headers = builder.headers;
        this.compressRequest = builder.compressRequest;
    }

    public final Method method() {
        return Method.fromValue(this.method);
    }

    public final String methodAsString() {
        return this.method;
    }

    public final String body() {
        return this.body;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> headers() {
        return this.headers;
    }

    public final CompressionMethod compressRequest() {
        return CompressionMethod.fromValue(this.compressRequest);
    }

    public final String compressRequestAsString() {
        return this.compressRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.compressRequestAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)obj;
        return Objects.equals(this.methodAsString(), other.methodAsString()) && Objects.equals(this.body(), other.body()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.compressRequestAsString(), other.compressRequestAsString());
    }

    public final String toString() {
        return ToString.builder((String)"HttpRequest").add("Method", (Object)this.methodAsString()).add("Body", (Object)this.body()).add("Headers", this.hasHeaders() ? this.headers() : null).add("CompressRequest", (Object)this.compressRequestAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Method": {
                return Optional.ofNullable(clazz.cast(this.methodAsString()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "Headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "CompressRequest": {
                return Optional.ofNullable(clazz.cast(this.compressRequestAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Method", METHOD_FIELD);
        map.put("Body", BODY_FIELD);
        map.put("Headers", HEADERS_FIELD);
        map.put("CompressRequest", COMPRESS_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpRequest, T> g) {
        return obj -> g.apply((HttpRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String method;
        private String body;
        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();
        private String compressRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRequest model) {
            this.method(model.method);
            this.body(model.body);
            this.headers(model.headers);
            this.compressRequest(model.compressRequest);
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(Method method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Map<String, String> getHeaders() {
            if (this.headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.headers;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = StringMapCopier.copy(headers);
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = StringMapCopier.copy(headers);
            return this;
        }

        public final String getCompressRequest() {
            return this.compressRequest;
        }

        public final void setCompressRequest(String compressRequest) {
            this.compressRequest = compressRequest;
        }

        @Override
        public final Builder compressRequest(String compressRequest) {
            this.compressRequest = compressRequest;
            return this;
        }

        @Override
        public final Builder compressRequest(CompressionMethod compressRequest) {
            this.compressRequest(compressRequest == null ? null : compressRequest.toString());
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpRequest> {
        public Builder method(String var1);

        public Builder method(Method var1);

        public Builder body(String var1);

        public Builder headers(Map<String, String> var1);

        public Builder compressRequest(String var1);

        public Builder compressRequest(CompressionMethod var1);
    }
}

