/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.CdnConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlaybackConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlaybackConfiguration> {
    private static final SdkField<String> AD_DECISION_SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlaybackConfiguration.getter(PlaybackConfiguration::adDecisionServerUrl)).setter(PlaybackConfiguration.setter(Builder::adDecisionServerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdDecisionServerUrl").build()}).build();
    private static final SdkField<CdnConfiguration> CDN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PlaybackConfiguration.getter(PlaybackConfiguration::cdnConfiguration)).setter(PlaybackConfiguration.setter(Builder::cdnConfiguration)).constructor(CdnConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlaybackConfiguration.getter(PlaybackConfiguration::name)).setter(PlaybackConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SLATE_AD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlaybackConfiguration.getter(PlaybackConfiguration::slateAdUrl)).setter(PlaybackConfiguration.setter(Builder::slateAdUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlateAdUrl").build()}).build();
    private static final SdkField<String> VIDEO_CONTENT_SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlaybackConfiguration.getter(PlaybackConfiguration::videoContentSourceUrl)).setter(PlaybackConfiguration.setter(Builder::videoContentSourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoContentSourceUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_DECISION_SERVER_URL_FIELD, CDN_CONFIGURATION_FIELD, NAME_FIELD, SLATE_AD_URL_FIELD, VIDEO_CONTENT_SOURCE_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adDecisionServerUrl;
    private final CdnConfiguration cdnConfiguration;
    private final String name;
    private final String slateAdUrl;
    private final String videoContentSourceUrl;

    private PlaybackConfiguration(BuilderImpl builder) {
        this.adDecisionServerUrl = builder.adDecisionServerUrl;
        this.cdnConfiguration = builder.cdnConfiguration;
        this.name = builder.name;
        this.slateAdUrl = builder.slateAdUrl;
        this.videoContentSourceUrl = builder.videoContentSourceUrl;
    }

    public String adDecisionServerUrl() {
        return this.adDecisionServerUrl;
    }

    public CdnConfiguration cdnConfiguration() {
        return this.cdnConfiguration;
    }

    public String name() {
        return this.name;
    }

    public String slateAdUrl() {
        return this.slateAdUrl;
    }

    public String videoContentSourceUrl() {
        return this.videoContentSourceUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adDecisionServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.slateAdUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoContentSourceUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaybackConfiguration)) {
            return false;
        }
        PlaybackConfiguration other = (PlaybackConfiguration)obj;
        return Objects.equals(this.adDecisionServerUrl(), other.adDecisionServerUrl()) && Objects.equals(this.cdnConfiguration(), other.cdnConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.slateAdUrl(), other.slateAdUrl()) && Objects.equals(this.videoContentSourceUrl(), other.videoContentSourceUrl());
    }

    public String toString() {
        return ToString.builder((String)"PlaybackConfiguration").add("AdDecisionServerUrl", (Object)this.adDecisionServerUrl()).add("CdnConfiguration", (Object)this.cdnConfiguration()).add("Name", (Object)this.name()).add("SlateAdUrl", (Object)this.slateAdUrl()).add("VideoContentSourceUrl", (Object)this.videoContentSourceUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdDecisionServerUrl": {
                return Optional.ofNullable(clazz.cast(this.adDecisionServerUrl()));
            }
            case "CdnConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cdnConfiguration()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SlateAdUrl": {
                return Optional.ofNullable(clazz.cast(this.slateAdUrl()));
            }
            case "VideoContentSourceUrl": {
                return Optional.ofNullable(clazz.cast(this.videoContentSourceUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlaybackConfiguration, T> g) {
        return obj -> g.apply((PlaybackConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adDecisionServerUrl;
        private CdnConfiguration cdnConfiguration;
        private String name;
        private String slateAdUrl;
        private String videoContentSourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PlaybackConfiguration model) {
            this.adDecisionServerUrl(model.adDecisionServerUrl);
            this.cdnConfiguration(model.cdnConfiguration);
            this.name(model.name);
            this.slateAdUrl(model.slateAdUrl);
            this.videoContentSourceUrl(model.videoContentSourceUrl);
        }

        public final String getAdDecisionServerUrl() {
            return this.adDecisionServerUrl;
        }

        @Override
        public final Builder adDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
            return this;
        }

        public final void setAdDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
        }

        public final CdnConfiguration.Builder getCdnConfiguration() {
            return this.cdnConfiguration != null ? this.cdnConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cdnConfiguration(CdnConfiguration cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration;
            return this;
        }

        public final void setCdnConfiguration(CdnConfiguration.BuilderImpl cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration != null ? cdnConfiguration.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSlateAdUrl() {
            return this.slateAdUrl;
        }

        @Override
        public final Builder slateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
            return this;
        }

        public final void setSlateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
        }

        public final String getVideoContentSourceUrl() {
            return this.videoContentSourceUrl;
        }

        @Override
        public final Builder videoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
            return this;
        }

        public final void setVideoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
        }

        public PlaybackConfiguration build() {
            return new PlaybackConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlaybackConfiguration> {
        public Builder adDecisionServerUrl(String var1);

        public Builder cdnConfiguration(CdnConfiguration var1);

        default public Builder cdnConfiguration(Consumer<CdnConfiguration.Builder> cdnConfiguration) {
            return this.cdnConfiguration((CdnConfiguration)((CdnConfiguration.Builder)CdnConfiguration.builder().applyMutation(cdnConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder slateAdUrl(String var1);

        public Builder videoContentSourceUrl(String var1);
    }
}

