/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.AdBreak;
import software.amazon.awssdk.services.mediatailor.model.AudienceMedia;
import software.amazon.awssdk.services.mediatailor.model.ClipRange;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorResponse;
import software.amazon.awssdk.services.mediatailor.model.___listOfAdBreakCopier;
import software.amazon.awssdk.services.mediatailor.model.___listOfAudienceMediaCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProgramResponse
extends MediaTailorResponse
implements ToCopyableBuilder<Builder, UpdateProgramResponse> {
    private static final SdkField<List<AdBreak>> AD_BREAKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdBreaks").getter(UpdateProgramResponse.getter(UpdateProgramResponse::adBreaks)).setter(UpdateProgramResponse.setter(Builder::adBreaks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreaks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdBreak::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateProgramResponse.getter(UpdateProgramResponse::arn)).setter(UpdateProgramResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<AudienceMedia>> AUDIENCE_MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudienceMedia").getter(UpdateProgramResponse.getter(UpdateProgramResponse::audienceMedia)).setter(UpdateProgramResponse.setter(Builder::audienceMedia)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudienceMedia").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudienceMedia::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(UpdateProgramResponse.getter(UpdateProgramResponse::channelName)).setter(UpdateProgramResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<ClipRange> CLIP_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClipRange").getter(UpdateProgramResponse.getter(UpdateProgramResponse::clipRange)).setter(UpdateProgramResponse.setter(Builder::clipRange)).constructor(ClipRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClipRange").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdateProgramResponse.getter(UpdateProgramResponse::creationTime)).setter(UpdateProgramResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMillis").getter(UpdateProgramResponse.getter(UpdateProgramResponse::durationMillis)).setter(UpdateProgramResponse.setter(Builder::durationMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()}).build();
    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LiveSourceName").getter(UpdateProgramResponse.getter(UpdateProgramResponse::liveSourceName)).setter(UpdateProgramResponse.setter(Builder::liveSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSourceName").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(UpdateProgramResponse.getter(UpdateProgramResponse::programName)).setter(UpdateProgramResponse.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramName").build()}).build();
    private static final SdkField<Instant> SCHEDULED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledStartTime").getter(UpdateProgramResponse.getter(UpdateProgramResponse::scheduledStartTime)).setter(UpdateProgramResponse.setter(Builder::scheduledStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLocationName").getter(UpdateProgramResponse.getter(UpdateProgramResponse::sourceLocationName)).setter(UpdateProgramResponse.setter(Builder::sourceLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build()}).build();
    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VodSourceName").getter(UpdateProgramResponse.getter(UpdateProgramResponse::vodSourceName)).setter(UpdateProgramResponse.setter(Builder::vodSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAKS_FIELD, ARN_FIELD, AUDIENCE_MEDIA_FIELD, CHANNEL_NAME_FIELD, CLIP_RANGE_FIELD, CREATION_TIME_FIELD, DURATION_MILLIS_FIELD, LIVE_SOURCE_NAME_FIELD, PROGRAM_NAME_FIELD, SCHEDULED_START_TIME_FIELD, SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AdBreaks", AD_BREAKS_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("AudienceMedia", AUDIENCE_MEDIA_FIELD);
            this.put("ChannelName", CHANNEL_NAME_FIELD);
            this.put("ClipRange", CLIP_RANGE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("DurationMillis", DURATION_MILLIS_FIELD);
            this.put("LiveSourceName", LIVE_SOURCE_NAME_FIELD);
            this.put("ProgramName", PROGRAM_NAME_FIELD);
            this.put("ScheduledStartTime", SCHEDULED_START_TIME_FIELD);
            this.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
            this.put("VodSourceName", VOD_SOURCE_NAME_FIELD);
        }
    });
    private final List<AdBreak> adBreaks;
    private final String arn;
    private final List<AudienceMedia> audienceMedia;
    private final String channelName;
    private final ClipRange clipRange;
    private final Instant creationTime;
    private final Long durationMillis;
    private final String liveSourceName;
    private final String programName;
    private final Instant scheduledStartTime;
    private final String sourceLocationName;
    private final String vodSourceName;

    private UpdateProgramResponse(BuilderImpl builder) {
        super(builder);
        this.adBreaks = builder.adBreaks;
        this.arn = builder.arn;
        this.audienceMedia = builder.audienceMedia;
        this.channelName = builder.channelName;
        this.clipRange = builder.clipRange;
        this.creationTime = builder.creationTime;
        this.durationMillis = builder.durationMillis;
        this.liveSourceName = builder.liveSourceName;
        this.programName = builder.programName;
        this.scheduledStartTime = builder.scheduledStartTime;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    public final boolean hasAdBreaks() {
        return this.adBreaks != null && !(this.adBreaks instanceof SdkAutoConstructList);
    }

    public final List<AdBreak> adBreaks() {
        return this.adBreaks;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAudienceMedia() {
        return this.audienceMedia != null && !(this.audienceMedia instanceof SdkAutoConstructList);
    }

    public final List<AudienceMedia> audienceMedia() {
        return this.audienceMedia;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final ClipRange clipRange() {
        return this.clipRange;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Long durationMillis() {
        return this.durationMillis;
    }

    public final String liveSourceName() {
        return this.liveSourceName;
    }

    public final String programName() {
        return this.programName;
    }

    public final Instant scheduledStartTime() {
        return this.scheduledStartTime;
    }

    public final String sourceLocationName() {
        return this.sourceLocationName;
    }

    public final String vodSourceName() {
        return this.vodSourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdBreaks() ? this.adBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudienceMedia() ? this.audienceMedia() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clipRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vodSourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProgramResponse)) {
            return false;
        }
        UpdateProgramResponse other = (UpdateProgramResponse)((Object)obj);
        return this.hasAdBreaks() == other.hasAdBreaks() && Objects.equals(this.adBreaks(), other.adBreaks()) && Objects.equals(this.arn(), other.arn()) && this.hasAudienceMedia() == other.hasAudienceMedia() && Objects.equals(this.audienceMedia(), other.audienceMedia()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.clipRange(), other.clipRange()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.durationMillis(), other.durationMillis()) && Objects.equals(this.liveSourceName(), other.liveSourceName()) && Objects.equals(this.programName(), other.programName()) && Objects.equals(this.scheduledStartTime(), other.scheduledStartTime()) && Objects.equals(this.sourceLocationName(), other.sourceLocationName()) && Objects.equals(this.vodSourceName(), other.vodSourceName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProgramResponse").add("AdBreaks", this.hasAdBreaks() ? this.adBreaks() : null).add("Arn", (Object)this.arn()).add("AudienceMedia", this.hasAudienceMedia() ? this.audienceMedia() : null).add("ChannelName", (Object)this.channelName()).add("ClipRange", (Object)this.clipRange()).add("CreationTime", (Object)this.creationTime()).add("DurationMillis", (Object)this.durationMillis()).add("LiveSourceName", (Object)this.liveSourceName()).add("ProgramName", (Object)this.programName()).add("ScheduledStartTime", (Object)this.scheduledStartTime()).add("SourceLocationName", (Object)this.sourceLocationName()).add("VodSourceName", (Object)this.vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdBreaks": {
                return Optional.ofNullable(clazz.cast(this.adBreaks()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AudienceMedia": {
                return Optional.ofNullable(clazz.cast(this.audienceMedia()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ClipRange": {
                return Optional.ofNullable(clazz.cast(this.clipRange()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DurationMillis": {
                return Optional.ofNullable(clazz.cast(this.durationMillis()));
            }
            case "LiveSourceName": {
                return Optional.ofNullable(clazz.cast(this.liveSourceName()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
            case "ScheduledStartTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledStartTime()));
            }
            case "SourceLocationName": {
                return Optional.ofNullable(clazz.cast(this.sourceLocationName()));
            }
            case "VodSourceName": {
                return Optional.ofNullable(clazz.cast(this.vodSourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProgramResponse, T> g) {
        return obj -> g.apply((UpdateProgramResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorResponse.BuilderImpl
    implements Builder {
        private List<AdBreak> adBreaks = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private List<AudienceMedia> audienceMedia = DefaultSdkAutoConstructList.getInstance();
        private String channelName;
        private ClipRange clipRange;
        private Instant creationTime;
        private Long durationMillis;
        private String liveSourceName;
        private String programName;
        private Instant scheduledStartTime;
        private String sourceLocationName;
        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProgramResponse model) {
            super(model);
            this.adBreaks(model.adBreaks);
            this.arn(model.arn);
            this.audienceMedia(model.audienceMedia);
            this.channelName(model.channelName);
            this.clipRange(model.clipRange);
            this.creationTime(model.creationTime);
            this.durationMillis(model.durationMillis);
            this.liveSourceName(model.liveSourceName);
            this.programName(model.programName);
            this.scheduledStartTime(model.scheduledStartTime);
            this.sourceLocationName(model.sourceLocationName);
            this.vodSourceName(model.vodSourceName);
        }

        public final List<AdBreak.Builder> getAdBreaks() {
            List<AdBreak.Builder> result = ___listOfAdBreakCopier.copyToBuilder(this.adBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreaks(Collection<AdBreak.BuilderImpl> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copyFromBuilder(adBreaks);
        }

        @Override
        public final Builder adBreaks(Collection<AdBreak> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copy(adBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(AdBreak ... adBreaks) {
            this.adBreaks(Arrays.asList(adBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(Consumer<AdBreak.Builder> ... adBreaks) {
            this.adBreaks(Stream.of(adBreaks).map(c -> (AdBreak)((AdBreak.Builder)AdBreak.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<AudienceMedia.Builder> getAudienceMedia() {
            List<AudienceMedia.Builder> result = ___listOfAudienceMediaCopier.copyToBuilder(this.audienceMedia);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceMedia(Collection<AudienceMedia.BuilderImpl> audienceMedia) {
            this.audienceMedia = ___listOfAudienceMediaCopier.copyFromBuilder(audienceMedia);
        }

        @Override
        public final Builder audienceMedia(Collection<AudienceMedia> audienceMedia) {
            this.audienceMedia = ___listOfAudienceMediaCopier.copy(audienceMedia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceMedia(AudienceMedia ... audienceMedia) {
            this.audienceMedia(Arrays.asList(audienceMedia));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceMedia(Consumer<AudienceMedia.Builder> ... audienceMedia) {
            this.audienceMedia(Stream.of(audienceMedia).map(c -> (AudienceMedia)((AudienceMedia.Builder)AudienceMedia.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final ClipRange.Builder getClipRange() {
            return this.clipRange != null ? this.clipRange.toBuilder() : null;
        }

        public final void setClipRange(ClipRange.BuilderImpl clipRange) {
            this.clipRange = clipRange != null ? clipRange.build() : null;
        }

        @Override
        public final Builder clipRange(ClipRange clipRange) {
            this.clipRange = clipRange;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getDurationMillis() {
            return this.durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final String getLiveSourceName() {
            return this.liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final String getProgramName() {
            return this.programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final Instant getScheduledStartTime() {
            return this.scheduledStartTime;
        }

        public final void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        @Override
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            return this;
        }

        public final String getSourceLocationName() {
            return this.sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final String getVodSourceName() {
            return this.vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        @Override
        public UpdateProgramResponse build() {
            return new UpdateProgramResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaTailorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProgramResponse> {
        public Builder adBreaks(Collection<AdBreak> var1);

        public Builder adBreaks(AdBreak ... var1);

        public Builder adBreaks(Consumer<AdBreak.Builder> ... var1);

        public Builder arn(String var1);

        public Builder audienceMedia(Collection<AudienceMedia> var1);

        public Builder audienceMedia(AudienceMedia ... var1);

        public Builder audienceMedia(Consumer<AudienceMedia.Builder> ... var1);

        public Builder channelName(String var1);

        public Builder clipRange(ClipRange var1);

        default public Builder clipRange(Consumer<ClipRange.Builder> clipRange) {
            return this.clipRange((ClipRange)((ClipRange.Builder)ClipRange.builder().applyMutation(clipRange)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder durationMillis(Long var1);

        public Builder liveSourceName(String var1);

        public Builder programName(String var1);

        public Builder scheduledStartTime(Instant var1);

        public Builder sourceLocationName(String var1);

        public Builder vodSourceName(String var1);
    }
}

