/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings;
import software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestOutputItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestOutputItem> {
    private static final SdkField<DashPlaylistSettings> DASH_PLAYLIST_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashPlaylistSettings").getter(RequestOutputItem.getter(RequestOutputItem::dashPlaylistSettings)).setter(RequestOutputItem.setter(Builder::dashPlaylistSettings)).constructor(DashPlaylistSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashPlaylistSettings").build()}).build();
    private static final SdkField<HlsPlaylistSettings> HLS_PLAYLIST_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsPlaylistSettings").getter(RequestOutputItem.getter(RequestOutputItem::hlsPlaylistSettings)).setter(RequestOutputItem.setter(Builder::hlsPlaylistSettings)).constructor(HlsPlaylistSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsPlaylistSettings").build()}).build();
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestName").getter(RequestOutputItem.getter(RequestOutputItem::manifestName)).setter(RequestOutputItem.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()}).build();
    private static final SdkField<String> SOURCE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceGroup").getter(RequestOutputItem.getter(RequestOutputItem::sourceGroup)).setter(RequestOutputItem.setter(Builder::sourceGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASH_PLAYLIST_SETTINGS_FIELD, HLS_PLAYLIST_SETTINGS_FIELD, MANIFEST_NAME_FIELD, SOURCE_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final DashPlaylistSettings dashPlaylistSettings;
    private final HlsPlaylistSettings hlsPlaylistSettings;
    private final String manifestName;
    private final String sourceGroup;

    private RequestOutputItem(BuilderImpl builder) {
        this.dashPlaylistSettings = builder.dashPlaylistSettings;
        this.hlsPlaylistSettings = builder.hlsPlaylistSettings;
        this.manifestName = builder.manifestName;
        this.sourceGroup = builder.sourceGroup;
    }

    public final DashPlaylistSettings dashPlaylistSettings() {
        return this.dashPlaylistSettings;
    }

    public final HlsPlaylistSettings hlsPlaylistSettings() {
        return this.hlsPlaylistSettings;
    }

    public final String manifestName() {
        return this.manifestName;
    }

    public final String sourceGroup() {
        return this.sourceGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashPlaylistSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsPlaylistSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestOutputItem)) {
            return false;
        }
        RequestOutputItem other = (RequestOutputItem)obj;
        return Objects.equals(this.dashPlaylistSettings(), other.dashPlaylistSettings()) && Objects.equals(this.hlsPlaylistSettings(), other.hlsPlaylistSettings()) && Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.sourceGroup(), other.sourceGroup());
    }

    public final String toString() {
        return ToString.builder((String)"RequestOutputItem").add("DashPlaylistSettings", (Object)this.dashPlaylistSettings()).add("HlsPlaylistSettings", (Object)this.hlsPlaylistSettings()).add("ManifestName", (Object)this.manifestName()).add("SourceGroup", (Object)this.sourceGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashPlaylistSettings": {
                return Optional.ofNullable(clazz.cast(this.dashPlaylistSettings()));
            }
            case "HlsPlaylistSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsPlaylistSettings()));
            }
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "SourceGroup": {
                return Optional.ofNullable(clazz.cast(this.sourceGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestOutputItem, T> g) {
        return obj -> g.apply((RequestOutputItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DashPlaylistSettings dashPlaylistSettings;
        private HlsPlaylistSettings hlsPlaylistSettings;
        private String manifestName;
        private String sourceGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestOutputItem model) {
            this.dashPlaylistSettings(model.dashPlaylistSettings);
            this.hlsPlaylistSettings(model.hlsPlaylistSettings);
            this.manifestName(model.manifestName);
            this.sourceGroup(model.sourceGroup);
        }

        public final DashPlaylistSettings.Builder getDashPlaylistSettings() {
            return this.dashPlaylistSettings != null ? this.dashPlaylistSettings.toBuilder() : null;
        }

        public final void setDashPlaylistSettings(DashPlaylistSettings.BuilderImpl dashPlaylistSettings) {
            this.dashPlaylistSettings = dashPlaylistSettings != null ? dashPlaylistSettings.build() : null;
        }

        @Override
        public final Builder dashPlaylistSettings(DashPlaylistSettings dashPlaylistSettings) {
            this.dashPlaylistSettings = dashPlaylistSettings;
            return this;
        }

        public final HlsPlaylistSettings.Builder getHlsPlaylistSettings() {
            return this.hlsPlaylistSettings != null ? this.hlsPlaylistSettings.toBuilder() : null;
        }

        public final void setHlsPlaylistSettings(HlsPlaylistSettings.BuilderImpl hlsPlaylistSettings) {
            this.hlsPlaylistSettings = hlsPlaylistSettings != null ? hlsPlaylistSettings.build() : null;
        }

        @Override
        public final Builder hlsPlaylistSettings(HlsPlaylistSettings hlsPlaylistSettings) {
            this.hlsPlaylistSettings = hlsPlaylistSettings;
            return this;
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getSourceGroup() {
            return this.sourceGroup;
        }

        public final void setSourceGroup(String sourceGroup) {
            this.sourceGroup = sourceGroup;
        }

        @Override
        public final Builder sourceGroup(String sourceGroup) {
            this.sourceGroup = sourceGroup;
            return this;
        }

        public RequestOutputItem build() {
            return new RequestOutputItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestOutputItem> {
        public Builder dashPlaylistSettings(DashPlaylistSettings var1);

        default public Builder dashPlaylistSettings(Consumer<DashPlaylistSettings.Builder> dashPlaylistSettings) {
            return this.dashPlaylistSettings((DashPlaylistSettings)((DashPlaylistSettings.Builder)DashPlaylistSettings.builder().applyMutation(dashPlaylistSettings)).build());
        }

        public Builder hlsPlaylistSettings(HlsPlaylistSettings var1);

        default public Builder hlsPlaylistSettings(Consumer<HlsPlaylistSettings.Builder> hlsPlaylistSettings) {
            return this.hlsPlaylistSettings((HlsPlaylistSettings)((HlsPlaylistSettings.Builder)HlsPlaylistSettings.builder().applyMutation(hlsPlaylistSettings)).build());
        }

        public Builder manifestName(String var1);

        public Builder sourceGroup(String var1);
    }
}

