/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.LogType;
import software.amazon.awssdk.services.mediatailor.model.LogTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfigurationForChannel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfigurationForChannel> {
    private static final SdkField<List<String>> LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogTypes").getter(LogConfigurationForChannel.getter(LogConfigurationForChannel::logTypesAsStrings)).setter(LogConfigurationForChannel.setter(Builder::logTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> logTypes;

    private LogConfigurationForChannel(BuilderImpl builder) {
        this.logTypes = builder.logTypes;
    }

    public final List<LogType> logTypes() {
        return LogTypesCopier.copyStringToEnum(this.logTypes);
    }

    public final boolean hasLogTypes() {
        return this.logTypes != null && !(this.logTypes instanceof SdkAutoConstructList);
    }

    public final List<String> logTypesAsStrings() {
        return this.logTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogTypes() ? this.logTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfigurationForChannel)) {
            return false;
        }
        LogConfigurationForChannel other = (LogConfigurationForChannel)obj;
        return this.hasLogTypes() == other.hasLogTypes() && Objects.equals(this.logTypesAsStrings(), other.logTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfigurationForChannel").add("LogTypes", this.hasLogTypes() ? this.logTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogTypes": {
                return Optional.ofNullable(clazz.cast(this.logTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfigurationForChannel, T> g) {
        return obj -> g.apply((LogConfigurationForChannel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> logTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfigurationForChannel model) {
            this.logTypesWithStrings(model.logTypes);
        }

        public final Collection<String> getLogTypes() {
            if (this.logTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logTypes;
        }

        public final void setLogTypes(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypesWithStrings(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesWithStrings(String ... logTypes) {
            this.logTypesWithStrings(Arrays.asList(logTypes));
            return this;
        }

        @Override
        public final Builder logTypes(Collection<LogType> logTypes) {
            this.logTypes = LogTypesCopier.copyEnumToString(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypes(LogType ... logTypes) {
            this.logTypes(Arrays.asList(logTypes));
            return this;
        }

        public LogConfigurationForChannel build() {
            return new LogConfigurationForChannel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfigurationForChannel> {
        public Builder logTypesWithStrings(Collection<String> var1);

        public Builder logTypesWithStrings(String ... var1);

        public Builder logTypes(Collection<LogType> var1);

        public Builder logTypes(LogType ... var1);
    }
}

