/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessType {
    S3_SIGV4("S3_SIGV4"),
    SECRETS_MANAGER_ACCESS_TOKEN("SECRETS_MANAGER_ACCESS_TOKEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessType> VALUE_MAP;
    private final String value;

    private AccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessType> knownValues() {
        EnumSet<AccessType> knownValues = EnumSet.allOf(AccessType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessType.class, AccessType::toString);
    }
}

