/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.AvailSuppression;
import software.amazon.awssdk.services.mediatailor.model.Bumper;
import software.amazon.awssdk.services.mediatailor.model.CdnConfiguration;
import software.amazon.awssdk.services.mediatailor.model.ConfigurationAliasesResponseCopier;
import software.amazon.awssdk.services.mediatailor.model.DashConfiguration;
import software.amazon.awssdk.services.mediatailor.model.HlsConfiguration;
import software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration;
import software.amazon.awssdk.services.mediatailor.model.LogConfiguration;
import software.amazon.awssdk.services.mediatailor.model.ManifestProcessingRules;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlaybackConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlaybackConfiguration> {
    private static final SdkField<String> AD_DECISION_SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdDecisionServerUrl").getter(PlaybackConfiguration.getter(PlaybackConfiguration::adDecisionServerUrl)).setter(PlaybackConfiguration.setter(Builder::adDecisionServerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdDecisionServerUrl").build()}).build();
    private static final SdkField<AvailSuppression> AVAIL_SUPPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailSuppression").getter(PlaybackConfiguration.getter(PlaybackConfiguration::availSuppression)).setter(PlaybackConfiguration.setter(Builder::availSuppression)).constructor(AvailSuppression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailSuppression").build()}).build();
    private static final SdkField<Bumper> BUMPER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bumper").getter(PlaybackConfiguration.getter(PlaybackConfiguration::bumper)).setter(PlaybackConfiguration.setter(Builder::bumper)).constructor(Bumper::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bumper").build()}).build();
    private static final SdkField<CdnConfiguration> CDN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CdnConfiguration").getter(PlaybackConfiguration.getter(PlaybackConfiguration::cdnConfiguration)).setter(PlaybackConfiguration.setter(Builder::cdnConfiguration)).constructor(CdnConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnConfiguration").build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> CONFIGURATION_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ConfigurationAliases").getter(PlaybackConfiguration.getter(PlaybackConfiguration::configurationAliases)).setter(PlaybackConfiguration.setter(Builder::configurationAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAliases").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<DashConfiguration> DASH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashConfiguration").getter(PlaybackConfiguration.getter(PlaybackConfiguration::dashConfiguration)).setter(PlaybackConfiguration.setter(Builder::dashConfiguration)).constructor(DashConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashConfiguration").build()}).build();
    private static final SdkField<HlsConfiguration> HLS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsConfiguration").getter(PlaybackConfiguration.getter(PlaybackConfiguration::hlsConfiguration)).setter(PlaybackConfiguration.setter(Builder::hlsConfiguration)).constructor(HlsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsConfiguration").build()}).build();
    private static final SdkField<LivePreRollConfiguration> LIVE_PRE_ROLL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LivePreRollConfiguration").getter(PlaybackConfiguration.getter(PlaybackConfiguration::livePreRollConfiguration)).setter(PlaybackConfiguration.setter(Builder::livePreRollConfiguration)).constructor(LivePreRollConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LivePreRollConfiguration").build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfiguration").getter(PlaybackConfiguration.getter(PlaybackConfiguration::logConfiguration)).setter(PlaybackConfiguration.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()}).build();
    private static final SdkField<ManifestProcessingRules> MANIFEST_PROCESSING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestProcessingRules").getter(PlaybackConfiguration.getter(PlaybackConfiguration::manifestProcessingRules)).setter(PlaybackConfiguration.setter(Builder::manifestProcessingRules)).constructor(ManifestProcessingRules::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestProcessingRules").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PlaybackConfiguration.getter(PlaybackConfiguration::name)).setter(PlaybackConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> PERSONALIZATION_THRESHOLD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PersonalizationThresholdSeconds").getter(PlaybackConfiguration.getter(PlaybackConfiguration::personalizationThresholdSeconds)).setter(PlaybackConfiguration.setter(Builder::personalizationThresholdSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalizationThresholdSeconds").build()}).build();
    private static final SdkField<String> PLAYBACK_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackConfigurationArn").getter(PlaybackConfiguration.getter(PlaybackConfiguration::playbackConfigurationArn)).setter(PlaybackConfiguration.setter(Builder::playbackConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationArn").build()}).build();
    private static final SdkField<String> PLAYBACK_ENDPOINT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackEndpointPrefix").getter(PlaybackConfiguration.getter(PlaybackConfiguration::playbackEndpointPrefix)).setter(PlaybackConfiguration.setter(Builder::playbackEndpointPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackEndpointPrefix").build()}).build();
    private static final SdkField<String> SESSION_INITIALIZATION_ENDPOINT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionInitializationEndpointPrefix").getter(PlaybackConfiguration.getter(PlaybackConfiguration::sessionInitializationEndpointPrefix)).setter(PlaybackConfiguration.setter(Builder::sessionInitializationEndpointPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionInitializationEndpointPrefix").build()}).build();
    private static final SdkField<String> SLATE_AD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlateAdUrl").getter(PlaybackConfiguration.getter(PlaybackConfiguration::slateAdUrl)).setter(PlaybackConfiguration.setter(Builder::slateAdUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlateAdUrl").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(PlaybackConfiguration.getter(PlaybackConfiguration::tags)).setter(PlaybackConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRANSCODE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscodeProfileName").getter(PlaybackConfiguration.getter(PlaybackConfiguration::transcodeProfileName)).setter(PlaybackConfiguration.setter(Builder::transcodeProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscodeProfileName").build()}).build();
    private static final SdkField<String> VIDEO_CONTENT_SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoContentSourceUrl").getter(PlaybackConfiguration.getter(PlaybackConfiguration::videoContentSourceUrl)).setter(PlaybackConfiguration.setter(Builder::videoContentSourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoContentSourceUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_DECISION_SERVER_URL_FIELD, AVAIL_SUPPRESSION_FIELD, BUMPER_FIELD, CDN_CONFIGURATION_FIELD, CONFIGURATION_ALIASES_FIELD, DASH_CONFIGURATION_FIELD, HLS_CONFIGURATION_FIELD, LIVE_PRE_ROLL_CONFIGURATION_FIELD, LOG_CONFIGURATION_FIELD, MANIFEST_PROCESSING_RULES_FIELD, NAME_FIELD, PERSONALIZATION_THRESHOLD_SECONDS_FIELD, PLAYBACK_CONFIGURATION_ARN_FIELD, PLAYBACK_ENDPOINT_PREFIX_FIELD, SESSION_INITIALIZATION_ENDPOINT_PREFIX_FIELD, SLATE_AD_URL_FIELD, TAGS_FIELD, TRANSCODE_PROFILE_NAME_FIELD, VIDEO_CONTENT_SOURCE_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adDecisionServerUrl;
    private final AvailSuppression availSuppression;
    private final Bumper bumper;
    private final CdnConfiguration cdnConfiguration;
    private final Map<String, Map<String, String>> configurationAliases;
    private final DashConfiguration dashConfiguration;
    private final HlsConfiguration hlsConfiguration;
    private final LivePreRollConfiguration livePreRollConfiguration;
    private final LogConfiguration logConfiguration;
    private final ManifestProcessingRules manifestProcessingRules;
    private final String name;
    private final Integer personalizationThresholdSeconds;
    private final String playbackConfigurationArn;
    private final String playbackEndpointPrefix;
    private final String sessionInitializationEndpointPrefix;
    private final String slateAdUrl;
    private final Map<String, String> tags;
    private final String transcodeProfileName;
    private final String videoContentSourceUrl;

    private PlaybackConfiguration(BuilderImpl builder) {
        this.adDecisionServerUrl = builder.adDecisionServerUrl;
        this.availSuppression = builder.availSuppression;
        this.bumper = builder.bumper;
        this.cdnConfiguration = builder.cdnConfiguration;
        this.configurationAliases = builder.configurationAliases;
        this.dashConfiguration = builder.dashConfiguration;
        this.hlsConfiguration = builder.hlsConfiguration;
        this.livePreRollConfiguration = builder.livePreRollConfiguration;
        this.logConfiguration = builder.logConfiguration;
        this.manifestProcessingRules = builder.manifestProcessingRules;
        this.name = builder.name;
        this.personalizationThresholdSeconds = builder.personalizationThresholdSeconds;
        this.playbackConfigurationArn = builder.playbackConfigurationArn;
        this.playbackEndpointPrefix = builder.playbackEndpointPrefix;
        this.sessionInitializationEndpointPrefix = builder.sessionInitializationEndpointPrefix;
        this.slateAdUrl = builder.slateAdUrl;
        this.tags = builder.tags;
        this.transcodeProfileName = builder.transcodeProfileName;
        this.videoContentSourceUrl = builder.videoContentSourceUrl;
    }

    public final String adDecisionServerUrl() {
        return this.adDecisionServerUrl;
    }

    public final AvailSuppression availSuppression() {
        return this.availSuppression;
    }

    public final Bumper bumper() {
        return this.bumper;
    }

    public final CdnConfiguration cdnConfiguration() {
        return this.cdnConfiguration;
    }

    public final boolean hasConfigurationAliases() {
        return this.configurationAliases != null && !(this.configurationAliases instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> configurationAliases() {
        return this.configurationAliases;
    }

    public final DashConfiguration dashConfiguration() {
        return this.dashConfiguration;
    }

    public final HlsConfiguration hlsConfiguration() {
        return this.hlsConfiguration;
    }

    public final LivePreRollConfiguration livePreRollConfiguration() {
        return this.livePreRollConfiguration;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final ManifestProcessingRules manifestProcessingRules() {
        return this.manifestProcessingRules;
    }

    public final String name() {
        return this.name;
    }

    public final Integer personalizationThresholdSeconds() {
        return this.personalizationThresholdSeconds;
    }

    public final String playbackConfigurationArn() {
        return this.playbackConfigurationArn;
    }

    public final String playbackEndpointPrefix() {
        return this.playbackEndpointPrefix;
    }

    public final String sessionInitializationEndpointPrefix() {
        return this.sessionInitializationEndpointPrefix;
    }

    public final String slateAdUrl() {
        return this.slateAdUrl;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String transcodeProfileName() {
        return this.transcodeProfileName;
    }

    public final String videoContentSourceUrl() {
        return this.videoContentSourceUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adDecisionServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.availSuppression());
        hashCode = 31 * hashCode + Objects.hashCode(this.bumper());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationAliases() ? this.configurationAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dashConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.livePreRollConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestProcessingRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalizationThresholdSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionInitializationEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.slateAdUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transcodeProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoContentSourceUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaybackConfiguration)) {
            return false;
        }
        PlaybackConfiguration other = (PlaybackConfiguration)obj;
        return Objects.equals(this.adDecisionServerUrl(), other.adDecisionServerUrl()) && Objects.equals(this.availSuppression(), other.availSuppression()) && Objects.equals(this.bumper(), other.bumper()) && Objects.equals(this.cdnConfiguration(), other.cdnConfiguration()) && this.hasConfigurationAliases() == other.hasConfigurationAliases() && Objects.equals(this.configurationAliases(), other.configurationAliases()) && Objects.equals(this.dashConfiguration(), other.dashConfiguration()) && Objects.equals(this.hlsConfiguration(), other.hlsConfiguration()) && Objects.equals(this.livePreRollConfiguration(), other.livePreRollConfiguration()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.manifestProcessingRules(), other.manifestProcessingRules()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.personalizationThresholdSeconds(), other.personalizationThresholdSeconds()) && Objects.equals(this.playbackConfigurationArn(), other.playbackConfigurationArn()) && Objects.equals(this.playbackEndpointPrefix(), other.playbackEndpointPrefix()) && Objects.equals(this.sessionInitializationEndpointPrefix(), other.sessionInitializationEndpointPrefix()) && Objects.equals(this.slateAdUrl(), other.slateAdUrl()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.transcodeProfileName(), other.transcodeProfileName()) && Objects.equals(this.videoContentSourceUrl(), other.videoContentSourceUrl());
    }

    public final String toString() {
        return ToString.builder((String)"PlaybackConfiguration").add("AdDecisionServerUrl", (Object)this.adDecisionServerUrl()).add("AvailSuppression", (Object)this.availSuppression()).add("Bumper", (Object)this.bumper()).add("CdnConfiguration", (Object)this.cdnConfiguration()).add("ConfigurationAliases", this.hasConfigurationAliases() ? this.configurationAliases() : null).add("DashConfiguration", (Object)this.dashConfiguration()).add("HlsConfiguration", (Object)this.hlsConfiguration()).add("LivePreRollConfiguration", (Object)this.livePreRollConfiguration()).add("LogConfiguration", (Object)this.logConfiguration()).add("ManifestProcessingRules", (Object)this.manifestProcessingRules()).add("Name", (Object)this.name()).add("PersonalizationThresholdSeconds", (Object)this.personalizationThresholdSeconds()).add("PlaybackConfigurationArn", (Object)this.playbackConfigurationArn()).add("PlaybackEndpointPrefix", (Object)this.playbackEndpointPrefix()).add("SessionInitializationEndpointPrefix", (Object)this.sessionInitializationEndpointPrefix()).add("SlateAdUrl", (Object)this.slateAdUrl()).add("Tags", this.hasTags() ? this.tags() : null).add("TranscodeProfileName", (Object)this.transcodeProfileName()).add("VideoContentSourceUrl", (Object)this.videoContentSourceUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdDecisionServerUrl": {
                return Optional.ofNullable(clazz.cast(this.adDecisionServerUrl()));
            }
            case "AvailSuppression": {
                return Optional.ofNullable(clazz.cast(this.availSuppression()));
            }
            case "Bumper": {
                return Optional.ofNullable(clazz.cast(this.bumper()));
            }
            case "CdnConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cdnConfiguration()));
            }
            case "ConfigurationAliases": {
                return Optional.ofNullable(clazz.cast(this.configurationAliases()));
            }
            case "DashConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dashConfiguration()));
            }
            case "HlsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.hlsConfiguration()));
            }
            case "LivePreRollConfiguration": {
                return Optional.ofNullable(clazz.cast(this.livePreRollConfiguration()));
            }
            case "LogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "ManifestProcessingRules": {
                return Optional.ofNullable(clazz.cast(this.manifestProcessingRules()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PersonalizationThresholdSeconds": {
                return Optional.ofNullable(clazz.cast(this.personalizationThresholdSeconds()));
            }
            case "PlaybackConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.playbackConfigurationArn()));
            }
            case "PlaybackEndpointPrefix": {
                return Optional.ofNullable(clazz.cast(this.playbackEndpointPrefix()));
            }
            case "SessionInitializationEndpointPrefix": {
                return Optional.ofNullable(clazz.cast(this.sessionInitializationEndpointPrefix()));
            }
            case "SlateAdUrl": {
                return Optional.ofNullable(clazz.cast(this.slateAdUrl()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TranscodeProfileName": {
                return Optional.ofNullable(clazz.cast(this.transcodeProfileName()));
            }
            case "VideoContentSourceUrl": {
                return Optional.ofNullable(clazz.cast(this.videoContentSourceUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlaybackConfiguration, T> g) {
        return obj -> g.apply((PlaybackConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adDecisionServerUrl;
        private AvailSuppression availSuppression;
        private Bumper bumper;
        private CdnConfiguration cdnConfiguration;
        private Map<String, Map<String, String>> configurationAliases = DefaultSdkAutoConstructMap.getInstance();
        private DashConfiguration dashConfiguration;
        private HlsConfiguration hlsConfiguration;
        private LivePreRollConfiguration livePreRollConfiguration;
        private LogConfiguration logConfiguration;
        private ManifestProcessingRules manifestProcessingRules;
        private String name;
        private Integer personalizationThresholdSeconds;
        private String playbackConfigurationArn;
        private String playbackEndpointPrefix;
        private String sessionInitializationEndpointPrefix;
        private String slateAdUrl;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String transcodeProfileName;
        private String videoContentSourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PlaybackConfiguration model) {
            this.adDecisionServerUrl(model.adDecisionServerUrl);
            this.availSuppression(model.availSuppression);
            this.bumper(model.bumper);
            this.cdnConfiguration(model.cdnConfiguration);
            this.configurationAliases(model.configurationAliases);
            this.dashConfiguration(model.dashConfiguration);
            this.hlsConfiguration(model.hlsConfiguration);
            this.livePreRollConfiguration(model.livePreRollConfiguration);
            this.logConfiguration(model.logConfiguration);
            this.manifestProcessingRules(model.manifestProcessingRules);
            this.name(model.name);
            this.personalizationThresholdSeconds(model.personalizationThresholdSeconds);
            this.playbackConfigurationArn(model.playbackConfigurationArn);
            this.playbackEndpointPrefix(model.playbackEndpointPrefix);
            this.sessionInitializationEndpointPrefix(model.sessionInitializationEndpointPrefix);
            this.slateAdUrl(model.slateAdUrl);
            this.tags(model.tags);
            this.transcodeProfileName(model.transcodeProfileName);
            this.videoContentSourceUrl(model.videoContentSourceUrl);
        }

        public final String getAdDecisionServerUrl() {
            return this.adDecisionServerUrl;
        }

        public final void setAdDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
        }

        @Override
        public final Builder adDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
            return this;
        }

        public final AvailSuppression.Builder getAvailSuppression() {
            return this.availSuppression != null ? this.availSuppression.toBuilder() : null;
        }

        public final void setAvailSuppression(AvailSuppression.BuilderImpl availSuppression) {
            this.availSuppression = availSuppression != null ? availSuppression.build() : null;
        }

        @Override
        public final Builder availSuppression(AvailSuppression availSuppression) {
            this.availSuppression = availSuppression;
            return this;
        }

        public final Bumper.Builder getBumper() {
            return this.bumper != null ? this.bumper.toBuilder() : null;
        }

        public final void setBumper(Bumper.BuilderImpl bumper) {
            this.bumper = bumper != null ? bumper.build() : null;
        }

        @Override
        public final Builder bumper(Bumper bumper) {
            this.bumper = bumper;
            return this;
        }

        public final CdnConfiguration.Builder getCdnConfiguration() {
            return this.cdnConfiguration != null ? this.cdnConfiguration.toBuilder() : null;
        }

        public final void setCdnConfiguration(CdnConfiguration.BuilderImpl cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration != null ? cdnConfiguration.build() : null;
        }

        @Override
        public final Builder cdnConfiguration(CdnConfiguration cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getConfigurationAliases() {
            if (this.configurationAliases instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configurationAliases;
        }

        public final void setConfigurationAliases(Map<String, ? extends Map<String, String>> configurationAliases) {
            this.configurationAliases = ConfigurationAliasesResponseCopier.copy(configurationAliases);
        }

        @Override
        public final Builder configurationAliases(Map<String, ? extends Map<String, String>> configurationAliases) {
            this.configurationAliases = ConfigurationAliasesResponseCopier.copy(configurationAliases);
            return this;
        }

        public final DashConfiguration.Builder getDashConfiguration() {
            return this.dashConfiguration != null ? this.dashConfiguration.toBuilder() : null;
        }

        public final void setDashConfiguration(DashConfiguration.BuilderImpl dashConfiguration) {
            this.dashConfiguration = dashConfiguration != null ? dashConfiguration.build() : null;
        }

        @Override
        public final Builder dashConfiguration(DashConfiguration dashConfiguration) {
            this.dashConfiguration = dashConfiguration;
            return this;
        }

        public final HlsConfiguration.Builder getHlsConfiguration() {
            return this.hlsConfiguration != null ? this.hlsConfiguration.toBuilder() : null;
        }

        public final void setHlsConfiguration(HlsConfiguration.BuilderImpl hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration != null ? hlsConfiguration.build() : null;
        }

        @Override
        public final Builder hlsConfiguration(HlsConfiguration hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration;
            return this;
        }

        public final LivePreRollConfiguration.Builder getLivePreRollConfiguration() {
            return this.livePreRollConfiguration != null ? this.livePreRollConfiguration.toBuilder() : null;
        }

        public final void setLivePreRollConfiguration(LivePreRollConfiguration.BuilderImpl livePreRollConfiguration) {
            this.livePreRollConfiguration = livePreRollConfiguration != null ? livePreRollConfiguration.build() : null;
        }

        @Override
        public final Builder livePreRollConfiguration(LivePreRollConfiguration livePreRollConfiguration) {
            this.livePreRollConfiguration = livePreRollConfiguration;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final ManifestProcessingRules.Builder getManifestProcessingRules() {
            return this.manifestProcessingRules != null ? this.manifestProcessingRules.toBuilder() : null;
        }

        public final void setManifestProcessingRules(ManifestProcessingRules.BuilderImpl manifestProcessingRules) {
            this.manifestProcessingRules = manifestProcessingRules != null ? manifestProcessingRules.build() : null;
        }

        @Override
        public final Builder manifestProcessingRules(ManifestProcessingRules manifestProcessingRules) {
            this.manifestProcessingRules = manifestProcessingRules;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPersonalizationThresholdSeconds() {
            return this.personalizationThresholdSeconds;
        }

        public final void setPersonalizationThresholdSeconds(Integer personalizationThresholdSeconds) {
            this.personalizationThresholdSeconds = personalizationThresholdSeconds;
        }

        @Override
        public final Builder personalizationThresholdSeconds(Integer personalizationThresholdSeconds) {
            this.personalizationThresholdSeconds = personalizationThresholdSeconds;
            return this;
        }

        public final String getPlaybackConfigurationArn() {
            return this.playbackConfigurationArn;
        }

        public final void setPlaybackConfigurationArn(String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
        }

        @Override
        public final Builder playbackConfigurationArn(String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
            return this;
        }

        public final String getPlaybackEndpointPrefix() {
            return this.playbackEndpointPrefix;
        }

        public final void setPlaybackEndpointPrefix(String playbackEndpointPrefix) {
            this.playbackEndpointPrefix = playbackEndpointPrefix;
        }

        @Override
        public final Builder playbackEndpointPrefix(String playbackEndpointPrefix) {
            this.playbackEndpointPrefix = playbackEndpointPrefix;
            return this;
        }

        public final String getSessionInitializationEndpointPrefix() {
            return this.sessionInitializationEndpointPrefix;
        }

        public final void setSessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix) {
            this.sessionInitializationEndpointPrefix = sessionInitializationEndpointPrefix;
        }

        @Override
        public final Builder sessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix) {
            this.sessionInitializationEndpointPrefix = sessionInitializationEndpointPrefix;
            return this;
        }

        public final String getSlateAdUrl() {
            return this.slateAdUrl;
        }

        public final void setSlateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
        }

        @Override
        public final Builder slateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTranscodeProfileName() {
            return this.transcodeProfileName;
        }

        public final void setTranscodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
        }

        @Override
        public final Builder transcodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
            return this;
        }

        public final String getVideoContentSourceUrl() {
            return this.videoContentSourceUrl;
        }

        public final void setVideoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
        }

        @Override
        public final Builder videoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
            return this;
        }

        public PlaybackConfiguration build() {
            return new PlaybackConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlaybackConfiguration> {
        public Builder adDecisionServerUrl(String var1);

        public Builder availSuppression(AvailSuppression var1);

        default public Builder availSuppression(Consumer<AvailSuppression.Builder> availSuppression) {
            return this.availSuppression((AvailSuppression)((AvailSuppression.Builder)AvailSuppression.builder().applyMutation(availSuppression)).build());
        }

        public Builder bumper(Bumper var1);

        default public Builder bumper(Consumer<Bumper.Builder> bumper) {
            return this.bumper((Bumper)((Bumper.Builder)Bumper.builder().applyMutation(bumper)).build());
        }

        public Builder cdnConfiguration(CdnConfiguration var1);

        default public Builder cdnConfiguration(Consumer<CdnConfiguration.Builder> cdnConfiguration) {
            return this.cdnConfiguration((CdnConfiguration)((CdnConfiguration.Builder)CdnConfiguration.builder().applyMutation(cdnConfiguration)).build());
        }

        public Builder configurationAliases(Map<String, ? extends Map<String, String>> var1);

        public Builder dashConfiguration(DashConfiguration var1);

        default public Builder dashConfiguration(Consumer<DashConfiguration.Builder> dashConfiguration) {
            return this.dashConfiguration((DashConfiguration)((DashConfiguration.Builder)DashConfiguration.builder().applyMutation(dashConfiguration)).build());
        }

        public Builder hlsConfiguration(HlsConfiguration var1);

        default public Builder hlsConfiguration(Consumer<HlsConfiguration.Builder> hlsConfiguration) {
            return this.hlsConfiguration((HlsConfiguration)((HlsConfiguration.Builder)HlsConfiguration.builder().applyMutation(hlsConfiguration)).build());
        }

        public Builder livePreRollConfiguration(LivePreRollConfiguration var1);

        default public Builder livePreRollConfiguration(Consumer<LivePreRollConfiguration.Builder> livePreRollConfiguration) {
            return this.livePreRollConfiguration((LivePreRollConfiguration)((LivePreRollConfiguration.Builder)LivePreRollConfiguration.builder().applyMutation(livePreRollConfiguration)).build());
        }

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder manifestProcessingRules(ManifestProcessingRules var1);

        default public Builder manifestProcessingRules(Consumer<ManifestProcessingRules.Builder> manifestProcessingRules) {
            return this.manifestProcessingRules((ManifestProcessingRules)((ManifestProcessingRules.Builder)ManifestProcessingRules.builder().applyMutation(manifestProcessingRules)).build());
        }

        public Builder name(String var1);

        public Builder personalizationThresholdSeconds(Integer var1);

        public Builder playbackConfigurationArn(String var1);

        public Builder playbackEndpointPrefix(String var1);

        public Builder sessionInitializationEndpointPrefix(String var1);

        public Builder slateAdUrl(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder transcodeProfileName(String var1);

        public Builder videoContentSourceUrl(String var1);
    }
}

