/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.ChannelState;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorResponse;
import software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem;
import software.amazon.awssdk.services.mediatailor.model.ResponseOutputsCopier;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeChannelResponse
extends MediaTailorResponse
implements ToCopyableBuilder<Builder, DescribeChannelResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeChannelResponse.getter(DescribeChannelResponse::arn)).setter(DescribeChannelResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(DescribeChannelResponse.getter(DescribeChannelResponse::channelName)).setter(DescribeChannelResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> CHANNEL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelState").getter(DescribeChannelResponse.getter(DescribeChannelResponse::channelStateAsString)).setter(DescribeChannelResponse.setter(Builder::channelState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelState").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeChannelResponse.getter(DescribeChannelResponse::creationTime)).setter(DescribeChannelResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeChannelResponse.getter(DescribeChannelResponse::lastModifiedTime)).setter(DescribeChannelResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<List<ResponseOutputItem>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(DescribeChannelResponse.getter(DescribeChannelResponse::outputs)).setter(DescribeChannelResponse.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponseOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLAYBACK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackMode").getter(DescribeChannelResponse.getter(DescribeChannelResponse::playbackMode)).setter(DescribeChannelResponse.setter(Builder::playbackMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackMode").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeChannelResponse.getter(DescribeChannelResponse::tags)).setter(DescribeChannelResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_NAME_FIELD, CHANNEL_STATE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, OUTPUTS_FIELD, PLAYBACK_MODE_FIELD, TAGS_FIELD));
    private final String arn;
    private final String channelName;
    private final String channelState;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final List<ResponseOutputItem> outputs;
    private final String playbackMode;
    private final Map<String, String> tags;

    private DescribeChannelResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.channelState = builder.channelState;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.outputs = builder.outputs;
        this.playbackMode = builder.playbackMode;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final ChannelState channelState() {
        return ChannelState.fromValue(this.channelState);
    }

    public final String channelStateAsString() {
        return this.channelState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<ResponseOutputItem> outputs() {
        return this.outputs;
    }

    public final String playbackMode() {
        return this.playbackMode;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelResponse)) {
            return false;
        }
        DescribeChannelResponse other = (DescribeChannelResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelStateAsString(), other.channelStateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.playbackMode(), other.playbackMode()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeChannelResponse").add("Arn", (Object)this.arn()).add("ChannelName", (Object)this.channelName()).add("ChannelState", (Object)this.channelStateAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("PlaybackMode", (Object)this.playbackMode()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ChannelState": {
                return Optional.ofNullable(clazz.cast(this.channelStateAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "PlaybackMode": {
                return Optional.ofNullable(clazz.cast(this.playbackMode()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelResponse, T> g) {
        return obj -> g.apply((DescribeChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String channelName;
        private String channelState;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private List<ResponseOutputItem> outputs = DefaultSdkAutoConstructList.getInstance();
        private String playbackMode;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelResponse model) {
            super(model);
            this.arn(model.arn);
            this.channelName(model.channelName);
            this.channelState(model.channelState);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.outputs(model.outputs);
            this.playbackMode(model.playbackMode);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        @Transient
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelState() {
            return this.channelState;
        }

        public final void setChannelState(String channelState) {
            this.channelState = channelState;
        }

        @Override
        @Transient
        public final Builder channelState(String channelState) {
            this.channelState = channelState;
            return this;
        }

        @Override
        @Transient
        public final Builder channelState(ChannelState channelState) {
            this.channelState(channelState == null ? null : channelState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<ResponseOutputItem.Builder> getOutputs() {
            List<ResponseOutputItem.Builder> result = ResponseOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<ResponseOutputItem.BuilderImpl> outputs) {
            this.outputs = ResponseOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Collection<ResponseOutputItem> outputs) {
            this.outputs = ResponseOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(ResponseOutputItem ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Consumer<ResponseOutputItem.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (ResponseOutputItem)((ResponseOutputItem.Builder)ResponseOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlaybackMode() {
            return this.playbackMode;
        }

        public final void setPlaybackMode(String playbackMode) {
            this.playbackMode = playbackMode;
        }

        @Override
        @Transient
        public final Builder playbackMode(String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeChannelResponse build() {
            return new DescribeChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeChannelResponse> {
        public Builder arn(String var1);

        public Builder channelName(String var1);

        public Builder channelState(String var1);

        public Builder channelState(ChannelState var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder outputs(Collection<ResponseOutputItem> var1);

        public Builder outputs(ResponseOutputItem ... var1);

        public Builder outputs(Consumer<ResponseOutputItem.Builder> ... var1);

        public Builder playbackMode(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

