/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.services.mediatailor.model.PlaybackMode;
import software.amazon.awssdk.services.mediatailor.model.RequestOutputItem;
import software.amazon.awssdk.services.mediatailor.model.RequestOutputsCopier;
import software.amazon.awssdk.services.mediatailor.model.SlateSource;
import software.amazon.awssdk.services.mediatailor.model.Tier;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, CreateChannelRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(CreateChannelRequest.getter(CreateChannelRequest::channelName)).setter(CreateChannelRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelName").build()}).build();
    private static final SdkField<SlateSource> FILLER_SLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FillerSlate").getter(CreateChannelRequest.getter(CreateChannelRequest::fillerSlate)).setter(CreateChannelRequest.setter(Builder::fillerSlate)).constructor(SlateSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillerSlate").build()}).build();
    private static final SdkField<List<RequestOutputItem>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(CreateChannelRequest.getter(CreateChannelRequest::outputs)).setter(CreateChannelRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLAYBACK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackMode").getter(CreateChannelRequest.getter(CreateChannelRequest::playbackModeAsString)).setter(CreateChannelRequest.setter(Builder::playbackMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackMode").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateChannelRequest.getter(CreateChannelRequest::tags)).setter(CreateChannelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(CreateChannelRequest.getter(CreateChannelRequest::tierAsString)).setter(CreateChannelRequest.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, FILLER_SLATE_FIELD, OUTPUTS_FIELD, PLAYBACK_MODE_FIELD, TAGS_FIELD, TIER_FIELD));
    private final String channelName;
    private final SlateSource fillerSlate;
    private final List<RequestOutputItem> outputs;
    private final String playbackMode;
    private final Map<String, String> tags;
    private final String tier;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.fillerSlate = builder.fillerSlate;
        this.outputs = builder.outputs;
        this.playbackMode = builder.playbackMode;
        this.tags = builder.tags;
        this.tier = builder.tier;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final SlateSource fillerSlate() {
        return this.fillerSlate;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<RequestOutputItem> outputs() {
        return this.outputs;
    }

    public final PlaybackMode playbackMode() {
        return PlaybackMode.fromValue(this.playbackMode);
    }

    public final String playbackModeAsString() {
        return this.playbackMode;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Tier tier() {
        return Tier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fillerSlate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)((Object)obj);
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.fillerSlate(), other.fillerSlate()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.playbackModeAsString(), other.playbackModeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.tierAsString(), other.tierAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelRequest").add("ChannelName", (Object)this.channelName()).add("FillerSlate", (Object)this.fillerSlate()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("PlaybackMode", (Object)this.playbackModeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Tier", (Object)this.tierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "FillerSlate": {
                return Optional.ofNullable(clazz.cast(this.fillerSlate()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "PlaybackMode": {
                return Optional.ofNullable(clazz.cast(this.playbackModeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private String channelName;
        private SlateSource fillerSlate;
        private List<RequestOutputItem> outputs = DefaultSdkAutoConstructList.getInstance();
        private String playbackMode;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            this.channelName(model.channelName);
            this.fillerSlate(model.fillerSlate);
            this.outputs(model.outputs);
            this.playbackMode(model.playbackMode);
            this.tags(model.tags);
            this.tier(model.tier);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final SlateSource.Builder getFillerSlate() {
            return this.fillerSlate != null ? this.fillerSlate.toBuilder() : null;
        }

        public final void setFillerSlate(SlateSource.BuilderImpl fillerSlate) {
            this.fillerSlate = fillerSlate != null ? fillerSlate.build() : null;
        }

        @Override
        public final Builder fillerSlate(SlateSource fillerSlate) {
            this.fillerSlate = fillerSlate;
            return this;
        }

        public final List<RequestOutputItem.Builder> getOutputs() {
            List<RequestOutputItem.Builder> result = RequestOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<RequestOutputItem.BuilderImpl> outputs) {
            this.outputs = RequestOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<RequestOutputItem> outputs) {
            this.outputs = RequestOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(RequestOutputItem ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<RequestOutputItem.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (RequestOutputItem)((RequestOutputItem.Builder)RequestOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlaybackMode() {
            return this.playbackMode;
        }

        public final void setPlaybackMode(String playbackMode) {
            this.playbackMode = playbackMode;
        }

        @Override
        public final Builder playbackMode(String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        @Override
        public final Builder playbackMode(PlaybackMode playbackMode) {
            this.playbackMode(playbackMode == null ? null : playbackMode.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelRequest> {
        public Builder channelName(String var1);

        public Builder fillerSlate(SlateSource var1);

        default public Builder fillerSlate(Consumer<SlateSource.Builder> fillerSlate) {
            return this.fillerSlate((SlateSource)((SlateSource.Builder)SlateSource.builder().applyMutation(fillerSlate)).build());
        }

        public Builder outputs(Collection<RequestOutputItem> var1);

        public Builder outputs(RequestOutputItem ... var1);

        public Builder outputs(Consumer<RequestOutputItem.Builder> ... var1);

        public Builder playbackMode(String var1);

        public Builder playbackMode(PlaybackMode var1);

        public Builder tags(Map<String, String> var1);

        public Builder tier(String var1);

        public Builder tier(Tier var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

