/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.OriginManifestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashConfiguration> {
    private static final SdkField<String> MANIFEST_ENDPOINT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestEndpointPrefix").getter(DashConfiguration.getter(DashConfiguration::manifestEndpointPrefix)).setter(DashConfiguration.setter(Builder::manifestEndpointPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestEndpointPrefix").build()}).build();
    private static final SdkField<String> MPD_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MpdLocation").getter(DashConfiguration.getter(DashConfiguration::mpdLocation)).setter(DashConfiguration.setter(Builder::mpdLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MpdLocation").build()}).build();
    private static final SdkField<String> ORIGIN_MANIFEST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginManifestType").getter(DashConfiguration.getter(DashConfiguration::originManifestTypeAsString)).setter(DashConfiguration.setter(Builder::originManifestType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginManifestType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_ENDPOINT_PREFIX_FIELD, MPD_LOCATION_FIELD, ORIGIN_MANIFEST_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String manifestEndpointPrefix;
    private final String mpdLocation;
    private final String originManifestType;

    private DashConfiguration(BuilderImpl builder) {
        this.manifestEndpointPrefix = builder.manifestEndpointPrefix;
        this.mpdLocation = builder.mpdLocation;
        this.originManifestType = builder.originManifestType;
    }

    public final String manifestEndpointPrefix() {
        return this.manifestEndpointPrefix;
    }

    public final String mpdLocation() {
        return this.mpdLocation;
    }

    public final OriginManifestType originManifestType() {
        return OriginManifestType.fromValue(this.originManifestType);
    }

    public final String originManifestTypeAsString() {
        return this.originManifestType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.originManifestTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashConfiguration)) {
            return false;
        }
        DashConfiguration other = (DashConfiguration)obj;
        return Objects.equals(this.manifestEndpointPrefix(), other.manifestEndpointPrefix()) && Objects.equals(this.mpdLocation(), other.mpdLocation()) && Objects.equals(this.originManifestTypeAsString(), other.originManifestTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DashConfiguration").add("ManifestEndpointPrefix", (Object)this.manifestEndpointPrefix()).add("MpdLocation", (Object)this.mpdLocation()).add("OriginManifestType", (Object)this.originManifestTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestEndpointPrefix": {
                return Optional.ofNullable(clazz.cast(this.manifestEndpointPrefix()));
            }
            case "MpdLocation": {
                return Optional.ofNullable(clazz.cast(this.mpdLocation()));
            }
            case "OriginManifestType": {
                return Optional.ofNullable(clazz.cast(this.originManifestTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashConfiguration, T> g) {
        return obj -> g.apply((DashConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String manifestEndpointPrefix;
        private String mpdLocation;
        private String originManifestType;

        private BuilderImpl() {
        }

        private BuilderImpl(DashConfiguration model) {
            this.manifestEndpointPrefix(model.manifestEndpointPrefix);
            this.mpdLocation(model.mpdLocation);
            this.originManifestType(model.originManifestType);
        }

        public final String getManifestEndpointPrefix() {
            return this.manifestEndpointPrefix;
        }

        public final void setManifestEndpointPrefix(String manifestEndpointPrefix) {
            this.manifestEndpointPrefix = manifestEndpointPrefix;
        }

        @Override
        @Transient
        public final Builder manifestEndpointPrefix(String manifestEndpointPrefix) {
            this.manifestEndpointPrefix = manifestEndpointPrefix;
            return this;
        }

        public final String getMpdLocation() {
            return this.mpdLocation;
        }

        public final void setMpdLocation(String mpdLocation) {
            this.mpdLocation = mpdLocation;
        }

        @Override
        @Transient
        public final Builder mpdLocation(String mpdLocation) {
            this.mpdLocation = mpdLocation;
            return this;
        }

        public final String getOriginManifestType() {
            return this.originManifestType;
        }

        public final void setOriginManifestType(String originManifestType) {
            this.originManifestType = originManifestType;
        }

        @Override
        @Transient
        public final Builder originManifestType(String originManifestType) {
            this.originManifestType = originManifestType;
            return this;
        }

        @Override
        @Transient
        public final Builder originManifestType(OriginManifestType originManifestType) {
            this.originManifestType(originManifestType == null ? null : originManifestType.toString());
            return this;
        }

        public DashConfiguration build() {
            return new DashConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashConfiguration> {
        public Builder manifestEndpointPrefix(String var1);

        public Builder mpdLocation(String var1);

        public Builder originManifestType(String var1);

        public Builder originManifestType(OriginManifestType var1);
    }
}

