/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.AccessType;
import software.amazon.awssdk.services.mediatailor.model.SecretsManagerAccessTokenConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessConfiguration> {
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessType").getter(AccessConfiguration.getter(AccessConfiguration::accessTypeAsString)).setter(AccessConfiguration.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()}).build();
    private static final SdkField<SecretsManagerAccessTokenConfiguration> SECRETS_MANAGER_ACCESS_TOKEN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManagerAccessTokenConfiguration").getter(AccessConfiguration.getter(AccessConfiguration::secretsManagerAccessTokenConfiguration)).setter(AccessConfiguration.setter(Builder::secretsManagerAccessTokenConfiguration)).constructor(SecretsManagerAccessTokenConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessTokenConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPE_FIELD, SECRETS_MANAGER_ACCESS_TOKEN_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessType;
    private final SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration;

    private AccessConfiguration(BuilderImpl builder) {
        this.accessType = builder.accessType;
        this.secretsManagerAccessTokenConfiguration = builder.secretsManagerAccessTokenConfiguration;
    }

    public final AccessType accessType() {
        return AccessType.fromValue(this.accessType);
    }

    public final String accessTypeAsString() {
        return this.accessType;
    }

    public final SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration() {
        return this.secretsManagerAccessTokenConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessTokenConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessConfiguration)) {
            return false;
        }
        AccessConfiguration other = (AccessConfiguration)obj;
        return Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(this.secretsManagerAccessTokenConfiguration(), other.secretsManagerAccessTokenConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AccessConfiguration").add("AccessType", (Object)this.accessTypeAsString()).add("SecretsManagerAccessTokenConfiguration", (Object)this.secretsManagerAccessTokenConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "SecretsManagerAccessTokenConfiguration": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessTokenConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessConfiguration, T> g) {
        return obj -> g.apply((AccessConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessType;
        private SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessConfiguration model) {
            this.accessType(model.accessType);
            this.secretsManagerAccessTokenConfiguration(model.secretsManagerAccessTokenConfiguration);
        }

        public final String getAccessType() {
            return this.accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(AccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        public final SecretsManagerAccessTokenConfiguration.Builder getSecretsManagerAccessTokenConfiguration() {
            return this.secretsManagerAccessTokenConfiguration != null ? this.secretsManagerAccessTokenConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder secretsManagerAccessTokenConfiguration(SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration) {
            this.secretsManagerAccessTokenConfiguration = secretsManagerAccessTokenConfiguration;
            return this;
        }

        public final void setSecretsManagerAccessTokenConfiguration(SecretsManagerAccessTokenConfiguration.BuilderImpl secretsManagerAccessTokenConfiguration) {
            this.secretsManagerAccessTokenConfiguration = secretsManagerAccessTokenConfiguration != null ? secretsManagerAccessTokenConfiguration.build() : null;
        }

        public AccessConfiguration build() {
            return new AccessConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessConfiguration> {
        public Builder accessType(String var1);

        public Builder accessType(AccessType var1);

        public Builder secretsManagerAccessTokenConfiguration(SecretsManagerAccessTokenConfiguration var1);

        default public Builder secretsManagerAccessTokenConfiguration(Consumer<SecretsManagerAccessTokenConfiguration.Builder> secretsManagerAccessTokenConfiguration) {
            return this.secretsManagerAccessTokenConfiguration((SecretsManagerAccessTokenConfiguration)((SecretsManagerAccessTokenConfiguration.Builder)SecretsManagerAccessTokenConfiguration.builder().applyMutation(secretsManagerAccessTokenConfiguration)).build());
        }
    }
}

