/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.model.ListProgramsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListProgramsResponse;
import software.amazon.awssdk.services.mediatailor.model.Program;

public class ListProgramsIterable
implements SdkIterable<ListProgramsResponse> {
    private final MediaTailorClient client;
    private final ListProgramsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProgramsIterable(MediaTailorClient client, ListProgramsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProgramsResponseFetcher();
    }

    public Iterator<ListProgramsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Program> items() {
        Function<ListProgramsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProgramsResponseFetcher
    implements SyncPageFetcher<ListProgramsResponse> {
        private ListProgramsResponseFetcher() {
        }

        public boolean hasNextPage(ListProgramsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProgramsResponse nextPage(ListProgramsResponse previousPage) {
            if (previousPage == null) {
                return ListProgramsIterable.this.client.listPrograms(ListProgramsIterable.this.firstRequest);
            }
            return ListProgramsIterable.this.client.listPrograms((ListProgramsRequest)((Object)ListProgramsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

