/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediastoredata.model.MediaStoreDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetObjectResponse
extends MediaStoreDataResponse
implements ToCopyableBuilder<Builder, GetObjectResponse> {
    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheControl").getter(GetObjectResponse.getter(GetObjectResponse::cacheControl)).setter(GetObjectResponse.setter(Builder::cacheControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Cache-Control").build()}).build();
    private static final SdkField<String> CONTENT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentRange").getter(GetObjectResponse.getter(GetObjectResponse::contentRange)).setter(GetObjectResponse.setter(Builder::contentRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Range").build()}).build();
    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ContentLength").getter(GetObjectResponse.getter(GetObjectResponse::contentLength)).setter(GetObjectResponse.setter(Builder::contentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Length").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(GetObjectResponse.getter(GetObjectResponse::contentType)).setter(GetObjectResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetObjectResponse.getter(GetObjectResponse::eTag)).setter(GetObjectResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(GetObjectResponse.getter(GetObjectResponse::lastModified)).setter(GetObjectResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Last-Modified").build()}).build();
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusCode").getter(GetObjectResponse.getter(GetObjectResponse::statusCode)).setter(GetObjectResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CONTROL_FIELD, CONTENT_RANGE_FIELD, CONTENT_LENGTH_FIELD, CONTENT_TYPE_FIELD, E_TAG_FIELD, LAST_MODIFIED_FIELD, STATUS_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetObjectResponse.memberNameToFieldInitializer();
    private final String cacheControl;
    private final String contentRange;
    private final Long contentLength;
    private final String contentType;
    private final String eTag;
    private final Instant lastModified;
    private final Integer statusCode;

    private GetObjectResponse(BuilderImpl builder) {
        super(builder);
        this.cacheControl = builder.cacheControl;
        this.contentRange = builder.contentRange;
        this.contentLength = builder.contentLength;
        this.contentType = builder.contentType;
        this.eTag = builder.eTag;
        this.lastModified = builder.lastModified;
        this.statusCode = builder.statusCode;
    }

    public final String cacheControl() {
        return this.cacheControl;
    }

    public final String contentRange() {
        return this.contentRange;
    }

    public final Long contentLength() {
        return this.contentLength;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final Integer statusCode() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectResponse)) {
            return false;
        }
        GetObjectResponse other = (GetObjectResponse)((Object)obj);
        return Objects.equals(this.cacheControl(), other.cacheControl()) && Objects.equals(this.contentRange(), other.contentRange()) && Objects.equals(this.contentLength(), other.contentLength()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.statusCode(), other.statusCode());
    }

    public final String toString() {
        return ToString.builder((String)"GetObjectResponse").add("CacheControl", (Object)this.cacheControl()).add("ContentRange", (Object)this.contentRange()).add("ContentLength", (Object)this.contentLength()).add("ContentType", (Object)this.contentType()).add("ETag", (Object)this.eTag()).add("LastModified", (Object)this.lastModified()).add("StatusCode", (Object)this.statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheControl": {
                return Optional.ofNullable(clazz.cast(this.cacheControl()));
            }
            case "ContentRange": {
                return Optional.ofNullable(clazz.cast(this.contentRange()));
            }
            case "ContentLength": {
                return Optional.ofNullable(clazz.cast(this.contentLength()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Cache-Control", CACHE_CONTROL_FIELD);
        map.put("Content-Range", CONTENT_RANGE_FIELD);
        map.put("Content-Length", CONTENT_LENGTH_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("Last-Modified", LAST_MODIFIED_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetObjectResponse, T> g) {
        return obj -> g.apply((GetObjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreDataResponse.BuilderImpl
    implements Builder {
        private String cacheControl;
        private String contentRange;
        private Long contentLength;
        private String contentType;
        private String eTag;
        private Instant lastModified;
        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectResponse model) {
            super(model);
            this.cacheControl(model.cacheControl);
            this.contentRange(model.contentRange);
            this.contentLength(model.contentLength);
            this.contentType(model.contentType);
            this.eTag(model.eTag);
            this.lastModified(model.lastModified);
            this.statusCode(model.statusCode);
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final String getContentRange() {
            return this.contentRange;
        }

        public final void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        @Override
        public final Builder contentRange(String contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public GetObjectResponse build() {
            return new GetObjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaStoreDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetObjectResponse> {
        public Builder cacheControl(String var1);

        public Builder contentRange(String var1);

        public Builder contentLength(Long var1);

        public Builder contentType(String var1);

        public Builder eTag(String var1);

        public Builder lastModified(Instant var1);

        public Builder statusCode(Integer var1);
    }
}

