/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediastore.DefaultMediaStoreAsyncClient;
import software.amazon.awssdk.services.mediastore.DefaultMediaStoreBaseClientBuilder;
import software.amazon.awssdk.services.mediastore.MediaStoreAsyncClient;
import software.amazon.awssdk.services.mediastore.MediaStoreAsyncClientBuilder;
import software.amazon.awssdk.services.mediastore.MediaStoreServiceClientConfiguration;
import software.amazon.awssdk.services.mediastore.endpoints.MediaStoreEndpointProvider;

@SdkInternalApi
final class DefaultMediaStoreAsyncClientBuilder
extends DefaultMediaStoreBaseClientBuilder<MediaStoreAsyncClientBuilder, MediaStoreAsyncClient>
implements MediaStoreAsyncClientBuilder {
    DefaultMediaStoreAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaStoreAsyncClientBuilder endpointProvider(MediaStoreEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaStoreAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaStoreAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MediaStoreServiceClientConfiguration serviceClientConfiguration = MediaStoreServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMediaStoreAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

