/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediastore.model.MediaStoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCorsPolicyRequest
extends MediaStoreRequest
implements ToCopyableBuilder<Builder, GetCorsPolicyRequest> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerName").getter(GetCorsPolicyRequest.getter(GetCorsPolicyRequest::containerName)).setter(GetCorsPolicyRequest.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD));
    private final String containerName;

    private GetCorsPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.containerName = builder.containerName;
    }

    public String containerName() {
        return this.containerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCorsPolicyRequest)) {
            return false;
        }
        GetCorsPolicyRequest other = (GetCorsPolicyRequest)((Object)obj);
        return Objects.equals(this.containerName(), other.containerName());
    }

    public String toString() {
        return ToString.builder((String)"GetCorsPolicyRequest").add("ContainerName", (Object)this.containerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCorsPolicyRequest, T> g) {
        return obj -> g.apply((GetCorsPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreRequest.BuilderImpl
    implements Builder {
        private String containerName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCorsPolicyRequest model) {
            super(model);
            this.containerName(model.containerName);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCorsPolicyRequest build() {
            return new GetCorsPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaStoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCorsPolicyRequest> {
        public Builder containerName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

