/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.mediastore.model.Container;
import software.amazon.awssdk.services.mediastore.model.ContainerListCopier;
import software.amazon.awssdk.services.mediastore.model.MediaStoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListContainersResponse
extends MediaStoreResponse
implements ToCopyableBuilder<Builder, ListContainersResponse> {
    private final List<Container> containers;
    private final String nextToken;

    private ListContainersResponse(BuilderImpl builder) {
        super(builder);
        this.containers = builder.containers;
        this.nextToken = builder.nextToken;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainersResponse)) {
            return false;
        }
        ListContainersResponse other = (ListContainersResponse)((Object)obj);
        return Objects.equals(this.containers(), other.containers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListContainersResponse").add("Containers", this.containers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Containers": {
                return Optional.of(clazz.cast(this.containers()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaStoreResponse.BuilderImpl
    implements Builder {
        private List<Container> containers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainersResponse model) {
            this.containers(model.containers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Container.Builder> getContainers() {
            return this.containers != null ? (Collection)this.containers.stream().map(Container::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainerListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainerListCopier.copyFromBuilder(containers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContainersResponse build() {
            return new ListContainersResponse(this);
        }
    }

    public static interface Builder
    extends MediaStoreResponse.Builder,
    CopyableBuilder<Builder, ListContainersResponse> {
        public Builder containers(Collection<Container> var1);

        public Builder containers(Container ... var1);

        public Builder nextToken(String var1);
    }
}

