/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.mediastore.model.MediaStoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeContainerRequest
extends MediaStoreRequest
implements ToCopyableBuilder<Builder, DescribeContainerRequest> {
    private final String containerName;

    private DescribeContainerRequest(BuilderImpl builder) {
        super(builder);
        this.containerName = builder.containerName;
    }

    public String containerName() {
        return this.containerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerRequest)) {
            return false;
        }
        DescribeContainerRequest other = (DescribeContainerRequest)((Object)obj);
        return Objects.equals(this.containerName(), other.containerName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeContainerRequest").add("ContainerName", (Object)this.containerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.of(clazz.cast(this.containerName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaStoreRequest.BuilderImpl
    implements Builder {
        private String containerName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContainerRequest model) {
            this.containerName(model.containerName);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeContainerRequest build() {
            return new DescribeContainerRequest(this);
        }
    }

    public static interface Builder
    extends MediaStoreRequest.Builder,
    CopyableBuilder<Builder, DescribeContainerRequest> {
        public Builder containerName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

