/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediastore.model.ContainerStatus;
import software.amazon.awssdk.services.mediastore.transform.ContainerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Container
implements StructuredPojo,
ToCopyableBuilder<Builder, Container> {
    private final String endpoint;
    private final Instant creationTime;
    private final String arn;
    private final String name;
    private final String status;

    private Container(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.creationTime = builder.creationTime;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public ContainerStatus status() {
        return ContainerStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        return ToString.builder((String)"Container").add("Endpoint", (Object)this.endpoint()).add("CreationTime", (Object)this.creationTime()).add("ARN", (Object)this.arn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private Instant creationTime;
        private String arn;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            this.endpoint(model.endpoint);
            this.creationTime(model.creationTime);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContainerStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public Container build() {
            return new Container(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Container> {
        public Builder endpoint(String var1);

        public Builder creationTime(Instant var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ContainerStatus var1);
    }
}

