/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionMethod {
    AES_128("AES_128"),
    SAMPLE_AES("SAMPLE_AES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionMethod> VALUE_MAP;
    private final String value;

    private EncryptionMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionMethod> knownValues() {
        EnumSet<EncryptionMethod> knownValues = EnumSet.allOf(EncryptionMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionMethod.class, EncryptionMethod::toString);
    }
}

