/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagevod.model.Authorization;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePackagingGroupRequest
extends MediaPackageVodRequest
implements ToCopyableBuilder<Builder, UpdatePackagingGroupRequest> {
    private static final SdkField<Authorization> AUTHORIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authorization").getter(UpdatePackagingGroupRequest.getter(UpdatePackagingGroupRequest::authorization)).setter(UpdatePackagingGroupRequest.setter(Builder::authorization)).constructor(Authorization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorization").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdatePackagingGroupRequest.getter(UpdatePackagingGroupRequest::id)).setter(UpdatePackagingGroupRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_FIELD, ID_FIELD));
    private final Authorization authorization;
    private final String id;

    private UpdatePackagingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.authorization = builder.authorization;
        this.id = builder.id;
    }

    public final Authorization authorization() {
        return this.authorization;
    }

    public final String id() {
        return this.id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorization());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackagingGroupRequest)) {
            return false;
        }
        UpdatePackagingGroupRequest other = (UpdatePackagingGroupRequest)((Object)obj);
        return Objects.equals(this.authorization(), other.authorization()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePackagingGroupRequest").add("Authorization", (Object)this.authorization()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authorization": {
                return Optional.ofNullable(clazz.cast(this.authorization()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackagingGroupRequest, T> g) {
        return obj -> g.apply((UpdatePackagingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodRequest.BuilderImpl
    implements Builder {
        private Authorization authorization;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackagingGroupRequest model) {
            super(model);
            this.authorization(model.authorization);
            this.id(model.id);
        }

        public final Authorization.Builder getAuthorization() {
            return this.authorization != null ? this.authorization.toBuilder() : null;
        }

        public final void setAuthorization(Authorization.BuilderImpl authorization) {
            this.authorization = authorization != null ? authorization.build() : null;
        }

        @Override
        @Transient
        public final Builder authorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackagingGroupRequest build() {
            return new UpdatePackagingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageVodRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePackagingGroupRequest> {
        public Builder authorization(Authorization var1);

        default public Builder authorization(Consumer<Authorization.Builder> authorization) {
            return this.authorization((Authorization)((Authorization.Builder)Authorization.builder().applyMutation(authorization)).build());
        }

        public Builder id(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

