/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScteMarkersSource {
    SEGMENTS("SEGMENTS"),
    MANIFEST("MANIFEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScteMarkersSource> VALUE_MAP;
    private final String value;

    private ScteMarkersSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScteMarkersSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScteMarkersSource> knownValues() {
        EnumSet<ScteMarkersSource> knownValues = EnumSet.allOf(ScteMarkersSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScteMarkersSource.class, ScteMarkersSource::toString);
    }
}

