/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagevod.MediaPackageVodAsyncClient;
import software.amazon.awssdk.services.mediapackagevod.model.AssetShallow;
import software.amazon.awssdk.services.mediapackagevod.model.ListAssetsRequest;
import software.amazon.awssdk.services.mediapackagevod.model.ListAssetsResponse;

public class ListAssetsPublisher
implements SdkPublisher<ListAssetsResponse> {
    private final MediaPackageVodAsyncClient client;
    private final ListAssetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetsPublisher(MediaPackageVodAsyncClient client, ListAssetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetsPublisher(MediaPackageVodAsyncClient client, ListAssetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetShallow> assets() {
        Function<ListAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assets() != null) {
                return response.assets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetsResponseFetcher
    implements AsyncPageFetcher<ListAssetsResponse> {
        private ListAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetsResponse> nextPage(ListAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetsPublisher.this.client.listAssets(ListAssetsPublisher.this.firstRequest);
            }
            return ListAssetsPublisher.this.client.listAssets((ListAssetsRequest)((Object)ListAssetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

