/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagevod.model.AdMarkers;
import software.amazon.awssdk.services.mediapackagevod.model.StreamSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsManifest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsManifest> {
    private static final SdkField<String> AD_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdMarkers").getter(HlsManifest.getter(HlsManifest::adMarkersAsString)).setter(HlsManifest.setter(Builder::adMarkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build()}).build();
    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeIframeOnlyStream").getter(HlsManifest.getter(HlsManifest::includeIframeOnlyStream)).setter(HlsManifest.setter(Builder::includeIframeOnlyStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeIframeOnlyStream").build()}).build();
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestName").getter(HlsManifest.getter(HlsManifest::manifestName)).setter(HlsManifest.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()}).build();
    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramDateTimeIntervalSeconds").getter(HlsManifest.getter(HlsManifest::programDateTimeIntervalSeconds)).setter(HlsManifest.setter(Builder::programDateTimeIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimeIntervalSeconds").build()}).build();
    private static final SdkField<Boolean> REPEAT_EXT_X_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RepeatExtXKey").getter(HlsManifest.getter(HlsManifest::repeatExtXKey)).setter(HlsManifest.setter(Builder::repeatExtXKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repeatExtXKey").build()}).build();
    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSelection").getter(HlsManifest.getter(HlsManifest::streamSelection)).setter(HlsManifest.setter(Builder::streamSelection)).constructor(StreamSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, INCLUDE_IFRAME_ONLY_STREAM_FIELD, MANIFEST_NAME_FIELD, PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD, REPEAT_EXT_X_KEY_FIELD, STREAM_SELECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adMarkers;
    private final Boolean includeIframeOnlyStream;
    private final String manifestName;
    private final Integer programDateTimeIntervalSeconds;
    private final Boolean repeatExtXKey;
    private final StreamSelection streamSelection;

    private HlsManifest(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.manifestName = builder.manifestName;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
        this.repeatExtXKey = builder.repeatExtXKey;
        this.streamSelection = builder.streamSelection;
    }

    public AdMarkers adMarkers() {
        return AdMarkers.fromValue(this.adMarkers);
    }

    public String adMarkersAsString() {
        return this.adMarkers;
    }

    public Boolean includeIframeOnlyStream() {
        return this.includeIframeOnlyStream;
    }

    public String manifestName() {
        return this.manifestName;
    }

    public Integer programDateTimeIntervalSeconds() {
        return this.programDateTimeIntervalSeconds;
    }

    public Boolean repeatExtXKey() {
        return this.repeatExtXKey;
    }

    public StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.repeatExtXKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsManifest)) {
            return false;
        }
        HlsManifest other = (HlsManifest)obj;
        return Objects.equals(this.adMarkersAsString(), other.adMarkersAsString()) && Objects.equals(this.includeIframeOnlyStream(), other.includeIframeOnlyStream()) && Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds()) && Objects.equals(this.repeatExtXKey(), other.repeatExtXKey()) && Objects.equals(this.streamSelection(), other.streamSelection());
    }

    public String toString() {
        return ToString.builder((String)"HlsManifest").add("AdMarkers", (Object)this.adMarkersAsString()).add("IncludeIframeOnlyStream", (Object)this.includeIframeOnlyStream()).add("ManifestName", (Object)this.manifestName()).add("ProgramDateTimeIntervalSeconds", (Object)this.programDateTimeIntervalSeconds()).add("RepeatExtXKey", (Object)this.repeatExtXKey()).add("StreamSelection", (Object)this.streamSelection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.ofNullable(clazz.cast(this.adMarkersAsString()));
            }
            case "IncludeIframeOnlyStream": {
                return Optional.ofNullable(clazz.cast(this.includeIframeOnlyStream()));
            }
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "ProgramDateTimeIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.programDateTimeIntervalSeconds()));
            }
            case "RepeatExtXKey": {
                return Optional.ofNullable(clazz.cast(this.repeatExtXKey()));
            }
            case "StreamSelection": {
                return Optional.ofNullable(clazz.cast(this.streamSelection()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsManifest, T> g) {
        return obj -> g.apply((HlsManifest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adMarkers;
        private Boolean includeIframeOnlyStream;
        private String manifestName;
        private Integer programDateTimeIntervalSeconds;
        private Boolean repeatExtXKey;
        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsManifest model) {
            this.adMarkers(model.adMarkers);
            this.includeIframeOnlyStream(model.includeIframeOnlyStream);
            this.manifestName(model.manifestName);
            this.programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
            this.repeatExtXKey(model.repeatExtXKey);
            this.streamSelection(model.streamSelection);
        }

        public final String getAdMarkers() {
            return this.adMarkers;
        }

        @Override
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers == null ? null : adMarkers.toString());
            return this;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return this.includeIframeOnlyStream;
        }

        @Override
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return this.programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        public final Boolean getRepeatExtXKey() {
            return this.repeatExtXKey;
        }

        @Override
        public final Builder repeatExtXKey(Boolean repeatExtXKey) {
            this.repeatExtXKey = repeatExtXKey;
            return this;
        }

        public final void setRepeatExtXKey(Boolean repeatExtXKey) {
            this.repeatExtXKey = repeatExtXKey;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public HlsManifest build() {
            return new HlsManifest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsManifest> {
        public Builder adMarkers(String var1);

        public Builder adMarkers(AdMarkers var1);

        public Builder includeIframeOnlyStream(Boolean var1);

        public Builder manifestName(String var1);

        public Builder programDateTimeIntervalSeconds(Integer var1);

        public Builder repeatExtXKey(Boolean var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().applyMutation(streamSelection)).build());
        }
    }
}

