/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for retrieving a specific harvest job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHarvestJobRequest extends MediaPackageV2Request implements
        ToCopyableBuilder<GetHarvestJobRequest.Builder, GetHarvestJobRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(GetHarvestJobRequest::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(GetHarvestJobRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(GetHarvestJobRequest::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OriginEndpointName").build()).build();

    private static final SdkField<String> HARVEST_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HarvestJobName").getter(getter(GetHarvestJobRequest::harvestJobName))
            .setter(setter(Builder::harvestJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("HarvestJobName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, HARVEST_JOB_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final String harvestJobName;

    private GetHarvestJobRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.harvestJobName = builder.harvestJobName;
    }

    /**
     * <p>
     * The name of the channel group containing the channel associated with the harvest job.
     * </p>
     * 
     * @return The name of the channel group containing the channel associated with the harvest job.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name of the channel associated with the harvest job.
     * </p>
     * 
     * @return The name of the channel associated with the harvest job.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name of the origin endpoint associated with the harvest job.
     * </p>
     * 
     * @return The name of the origin endpoint associated with the harvest job.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * The name of the harvest job to retrieve.
     * </p>
     * 
     * @return The name of the harvest job to retrieve.
     */
    public final String harvestJobName() {
        return harvestJobName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(harvestJobName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHarvestJobRequest)) {
            return false;
        }
        GetHarvestJobRequest other = (GetHarvestJobRequest) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName())
                && Objects.equals(harvestJobName(), other.harvestJobName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHarvestJobRequest").add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("OriginEndpointName", originEndpointName())
                .add("HarvestJobName", harvestJobName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "HarvestJobName":
            return Optional.ofNullable(clazz.cast(harvestJobName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("OriginEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
        map.put("HarvestJobName", HARVEST_JOB_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHarvestJobRequest, T> g) {
        return obj -> g.apply((GetHarvestJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaPackageV2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetHarvestJobRequest> {
        /**
         * <p>
         * The name of the channel group containing the channel associated with the harvest job.
         * </p>
         * 
         * @param channelGroupName
         *        The name of the channel group containing the channel associated with the harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name of the channel associated with the harvest job.
         * </p>
         * 
         * @param channelName
         *        The name of the channel associated with the harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name of the origin endpoint associated with the harvest job.
         * </p>
         * 
         * @param originEndpointName
         *        The name of the origin endpoint associated with the harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * The name of the harvest job to retrieve.
         * </p>
         * 
         * @param harvestJobName
         *        The name of the harvest job to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestJobName(String harvestJobName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageV2Request.BuilderImpl implements Builder {
        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private String harvestJobName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHarvestJobRequest model) {
            super(model);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            harvestJobName(model.harvestJobName);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getHarvestJobName() {
            return harvestJobName;
        }

        public final void setHarvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
        }

        @Override
        public final Builder harvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHarvestJobRequest build() {
            return new GetHarvestJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
