/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionMethod implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionMethod.Builder, EncryptionMethod> {
    private static final SdkField<String> TS_ENCRYPTION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TsEncryptionMethod").getter(getter(EncryptionMethod::tsEncryptionMethodAsString))
            .setter(setter(Builder::tsEncryptionMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TsEncryptionMethod").build())
            .build();

    private static final SdkField<String> CMAF_ENCRYPTION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CmafEncryptionMethod").getter(getter(EncryptionMethod::cmafEncryptionMethodAsString))
            .setter(setter(Builder::cmafEncryptionMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmafEncryptionMethod").build())
            .build();

    private static final SdkField<String> ISM_ENCRYPTION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsmEncryptionMethod").getter(getter(EncryptionMethod::ismEncryptionMethodAsString))
            .setter(setter(Builder::ismEncryptionMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsmEncryptionMethod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TS_ENCRYPTION_METHOD_FIELD,
            CMAF_ENCRYPTION_METHOD_FIELD, ISM_ENCRYPTION_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tsEncryptionMethod;

    private final String cmafEncryptionMethod;

    private final String ismEncryptionMethod;

    private EncryptionMethod(BuilderImpl builder) {
        this.tsEncryptionMethod = builder.tsEncryptionMethod;
        this.cmafEncryptionMethod = builder.cmafEncryptionMethod;
        this.ismEncryptionMethod = builder.ismEncryptionMethod;
    }

    /**
     * <p>
     * The encryption method to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tsEncryptionMethod} will return {@link TsEncryptionMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #tsEncryptionMethodAsString}.
     * </p>
     * 
     * @return The encryption method to use.
     * @see TsEncryptionMethod
     */
    public final TsEncryptionMethod tsEncryptionMethod() {
        return TsEncryptionMethod.fromValue(tsEncryptionMethod);
    }

    /**
     * <p>
     * The encryption method to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tsEncryptionMethod} will return {@link TsEncryptionMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #tsEncryptionMethodAsString}.
     * </p>
     * 
     * @return The encryption method to use.
     * @see TsEncryptionMethod
     */
    public final String tsEncryptionMethodAsString() {
        return tsEncryptionMethod;
    }

    /**
     * <p>
     * The encryption method to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cmafEncryptionMethod} will return {@link CmafEncryptionMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cmafEncryptionMethodAsString}.
     * </p>
     * 
     * @return The encryption method to use.
     * @see CmafEncryptionMethod
     */
    public final CmafEncryptionMethod cmafEncryptionMethod() {
        return CmafEncryptionMethod.fromValue(cmafEncryptionMethod);
    }

    /**
     * <p>
     * The encryption method to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cmafEncryptionMethod} will return {@link CmafEncryptionMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cmafEncryptionMethodAsString}.
     * </p>
     * 
     * @return The encryption method to use.
     * @see CmafEncryptionMethod
     */
    public final String cmafEncryptionMethodAsString() {
        return cmafEncryptionMethod;
    }

    /**
     * <p>
     * The encryption method used for Microsoft Smooth Streaming (MSS) content. This specifies how the MSS segments are
     * encrypted to protect the content during delivery to client players.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ismEncryptionMethod} will return {@link IsmEncryptionMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ismEncryptionMethodAsString}.
     * </p>
     * 
     * @return The encryption method used for Microsoft Smooth Streaming (MSS) content. This specifies how the MSS
     *         segments are encrypted to protect the content during delivery to client players.
     * @see IsmEncryptionMethod
     */
    public final IsmEncryptionMethod ismEncryptionMethod() {
        return IsmEncryptionMethod.fromValue(ismEncryptionMethod);
    }

    /**
     * <p>
     * The encryption method used for Microsoft Smooth Streaming (MSS) content. This specifies how the MSS segments are
     * encrypted to protect the content during delivery to client players.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ismEncryptionMethod} will return {@link IsmEncryptionMethod#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #ismEncryptionMethodAsString}.
     * </p>
     * 
     * @return The encryption method used for Microsoft Smooth Streaming (MSS) content. This specifies how the MSS
     *         segments are encrypted to protect the content during delivery to client players.
     * @see IsmEncryptionMethod
     */
    public final String ismEncryptionMethodAsString() {
        return ismEncryptionMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tsEncryptionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cmafEncryptionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ismEncryptionMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionMethod)) {
            return false;
        }
        EncryptionMethod other = (EncryptionMethod) obj;
        return Objects.equals(tsEncryptionMethodAsString(), other.tsEncryptionMethodAsString())
                && Objects.equals(cmafEncryptionMethodAsString(), other.cmafEncryptionMethodAsString())
                && Objects.equals(ismEncryptionMethodAsString(), other.ismEncryptionMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionMethod").add("TsEncryptionMethod", tsEncryptionMethodAsString())
                .add("CmafEncryptionMethod", cmafEncryptionMethodAsString())
                .add("IsmEncryptionMethod", ismEncryptionMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TsEncryptionMethod":
            return Optional.ofNullable(clazz.cast(tsEncryptionMethodAsString()));
        case "CmafEncryptionMethod":
            return Optional.ofNullable(clazz.cast(cmafEncryptionMethodAsString()));
        case "IsmEncryptionMethod":
            return Optional.ofNullable(clazz.cast(ismEncryptionMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TsEncryptionMethod", TS_ENCRYPTION_METHOD_FIELD);
        map.put("CmafEncryptionMethod", CMAF_ENCRYPTION_METHOD_FIELD);
        map.put("IsmEncryptionMethod", ISM_ENCRYPTION_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionMethod, T> g) {
        return obj -> g.apply((EncryptionMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionMethod> {
        /**
         * <p>
         * The encryption method to use.
         * </p>
         * 
         * @param tsEncryptionMethod
         *        The encryption method to use.
         * @see TsEncryptionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TsEncryptionMethod
         */
        Builder tsEncryptionMethod(String tsEncryptionMethod);

        /**
         * <p>
         * The encryption method to use.
         * </p>
         * 
         * @param tsEncryptionMethod
         *        The encryption method to use.
         * @see TsEncryptionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TsEncryptionMethod
         */
        Builder tsEncryptionMethod(TsEncryptionMethod tsEncryptionMethod);

        /**
         * <p>
         * The encryption method to use.
         * </p>
         * 
         * @param cmafEncryptionMethod
         *        The encryption method to use.
         * @see CmafEncryptionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafEncryptionMethod
         */
        Builder cmafEncryptionMethod(String cmafEncryptionMethod);

        /**
         * <p>
         * The encryption method to use.
         * </p>
         * 
         * @param cmafEncryptionMethod
         *        The encryption method to use.
         * @see CmafEncryptionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafEncryptionMethod
         */
        Builder cmafEncryptionMethod(CmafEncryptionMethod cmafEncryptionMethod);

        /**
         * <p>
         * The encryption method used for Microsoft Smooth Streaming (MSS) content. This specifies how the MSS segments
         * are encrypted to protect the content during delivery to client players.
         * </p>
         * 
         * @param ismEncryptionMethod
         *        The encryption method used for Microsoft Smooth Streaming (MSS) content. This specifies how the MSS
         *        segments are encrypted to protect the content during delivery to client players.
         * @see IsmEncryptionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsmEncryptionMethod
         */
        Builder ismEncryptionMethod(String ismEncryptionMethod);

        /**
         * <p>
         * The encryption method used for Microsoft Smooth Streaming (MSS) content. This specifies how the MSS segments
         * are encrypted to protect the content during delivery to client players.
         * </p>
         * 
         * @param ismEncryptionMethod
         *        The encryption method used for Microsoft Smooth Streaming (MSS) content. This specifies how the MSS
         *        segments are encrypted to protect the content during delivery to client players.
         * @see IsmEncryptionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsmEncryptionMethod
         */
        Builder ismEncryptionMethod(IsmEncryptionMethod ismEncryptionMethod);
    }

    static final class BuilderImpl implements Builder {
        private String tsEncryptionMethod;

        private String cmafEncryptionMethod;

        private String ismEncryptionMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionMethod model) {
            tsEncryptionMethod(model.tsEncryptionMethod);
            cmafEncryptionMethod(model.cmafEncryptionMethod);
            ismEncryptionMethod(model.ismEncryptionMethod);
        }

        public final String getTsEncryptionMethod() {
            return tsEncryptionMethod;
        }

        public final void setTsEncryptionMethod(String tsEncryptionMethod) {
            this.tsEncryptionMethod = tsEncryptionMethod;
        }

        @Override
        public final Builder tsEncryptionMethod(String tsEncryptionMethod) {
            this.tsEncryptionMethod = tsEncryptionMethod;
            return this;
        }

        @Override
        public final Builder tsEncryptionMethod(TsEncryptionMethod tsEncryptionMethod) {
            this.tsEncryptionMethod(tsEncryptionMethod == null ? null : tsEncryptionMethod.toString());
            return this;
        }

        public final String getCmafEncryptionMethod() {
            return cmafEncryptionMethod;
        }

        public final void setCmafEncryptionMethod(String cmafEncryptionMethod) {
            this.cmafEncryptionMethod = cmafEncryptionMethod;
        }

        @Override
        public final Builder cmafEncryptionMethod(String cmafEncryptionMethod) {
            this.cmafEncryptionMethod = cmafEncryptionMethod;
            return this;
        }

        @Override
        public final Builder cmafEncryptionMethod(CmafEncryptionMethod cmafEncryptionMethod) {
            this.cmafEncryptionMethod(cmafEncryptionMethod == null ? null : cmafEncryptionMethod.toString());
            return this;
        }

        public final String getIsmEncryptionMethod() {
            return ismEncryptionMethod;
        }

        public final void setIsmEncryptionMethod(String ismEncryptionMethod) {
            this.ismEncryptionMethod = ismEncryptionMethod;
        }

        @Override
        public final Builder ismEncryptionMethod(String ismEncryptionMethod) {
            this.ismEncryptionMethod = ismEncryptionMethod;
            return this;
        }

        @Override
        public final Builder ismEncryptionMethod(IsmEncryptionMethod ismEncryptionMethod) {
            this.ismEncryptionMethod(ismEncryptionMethod == null ? null : ismEncryptionMethod.toString());
            return this;
        }

        @Override
        public EncryptionMethod build() {
            return new EncryptionMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
