/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters for creating a Microsoft Smooth Streaming (MSS) manifest. MSS is a streaming media format
 * developed by Microsoft that delivers adaptive bitrate streaming content to compatible players and devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMssManifestConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateMssManifestConfiguration.Builder, CreateMssManifestConfiguration> {
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestName").getter(getter(CreateMssManifestConfiguration::manifestName))
            .setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()).build();

    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManifestWindowSeconds").getter(getter(CreateMssManifestConfiguration::manifestWindowSeconds))
            .setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build())
            .build();

    private static final SdkField<FilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField
            .<FilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("FilterConfiguration")
            .getter(getter(CreateMssManifestConfiguration::filterConfiguration)).setter(setter(Builder::filterConfiguration))
            .constructor(FilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConfiguration").build())
            .build();

    private static final SdkField<String> MANIFEST_LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestLayout").getter(getter(CreateMssManifestConfiguration::manifestLayoutAsString))
            .setter(setter(Builder::manifestLayout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestLayout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_FIELD,
            MANIFEST_WINDOW_SECONDS_FIELD, FILTER_CONFIGURATION_FIELD, MANIFEST_LAYOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String manifestName;

    private final Integer manifestWindowSeconds;

    private final FilterConfiguration filterConfiguration;

    private final String manifestLayout;

    private CreateMssManifestConfiguration(BuilderImpl builder) {
        this.manifestName = builder.manifestName;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.filterConfiguration = builder.filterConfiguration;
        this.manifestLayout = builder.manifestLayout;
    }

    /**
     * <p>
     * A short string that's appended to the endpoint URL to create a unique path to this MSS manifest. The manifest
     * name must be unique within the origin endpoint and can contain letters, numbers, hyphens, and underscores.
     * </p>
     * 
     * @return A short string that's appended to the endpoint URL to create a unique path to this MSS manifest. The
     *         manifest name must be unique within the origin endpoint and can contain letters, numbers, hyphens, and
     *         underscores.
     */
    public final String manifestName() {
        return manifestName;
    }

    /**
     * <p>
     * The total duration (in seconds) of the manifest window. This determines how much content is available in the
     * manifest at any given time. The manifest window slides forward as new segments become available, maintaining a
     * consistent duration of content. The minimum value is 30 seconds.
     * </p>
     * 
     * @return The total duration (in seconds) of the manifest window. This determines how much content is available in
     *         the manifest at any given time. The manifest window slides forward as new segments become available,
     *         maintaining a consistent duration of content. The minimum value is 30 seconds.
     */
    public final Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    /**
     * Returns the value of the FilterConfiguration property for this object.
     * 
     * @return The value of the FilterConfiguration property for this object.
     */
    public final FilterConfiguration filterConfiguration() {
        return filterConfiguration;
    }

    /**
     * <p>
     * Determines the layout format of the MSS manifest. This controls how the manifest is structured and presented to
     * client players, affecting compatibility with different MSS-compatible devices and applications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #manifestLayout}
     * will return {@link MssManifestLayout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #manifestLayoutAsString}.
     * </p>
     * 
     * @return Determines the layout format of the MSS manifest. This controls how the manifest is structured and
     *         presented to client players, affecting compatibility with different MSS-compatible devices and
     *         applications.
     * @see MssManifestLayout
     */
    public final MssManifestLayout manifestLayout() {
        return MssManifestLayout.fromValue(manifestLayout);
    }

    /**
     * <p>
     * Determines the layout format of the MSS manifest. This controls how the manifest is structured and presented to
     * client players, affecting compatibility with different MSS-compatible devices and applications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #manifestLayout}
     * will return {@link MssManifestLayout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #manifestLayoutAsString}.
     * </p>
     * 
     * @return Determines the layout format of the MSS manifest. This controls how the manifest is structured and
     *         presented to client players, affecting compatibility with different MSS-compatible devices and
     *         applications.
     * @see MssManifestLayout
     */
    public final String manifestLayoutAsString() {
        return manifestLayout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(filterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(manifestLayoutAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMssManifestConfiguration)) {
            return false;
        }
        CreateMssManifestConfiguration other = (CreateMssManifestConfiguration) obj;
        return Objects.equals(manifestName(), other.manifestName())
                && Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds())
                && Objects.equals(filterConfiguration(), other.filterConfiguration())
                && Objects.equals(manifestLayoutAsString(), other.manifestLayoutAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMssManifestConfiguration").add("ManifestName", manifestName())
                .add("ManifestWindowSeconds", manifestWindowSeconds()).add("FilterConfiguration", filterConfiguration())
                .add("ManifestLayout", manifestLayoutAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        case "FilterConfiguration":
            return Optional.ofNullable(clazz.cast(filterConfiguration()));
        case "ManifestLayout":
            return Optional.ofNullable(clazz.cast(manifestLayoutAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManifestName", MANIFEST_NAME_FIELD);
        map.put("ManifestWindowSeconds", MANIFEST_WINDOW_SECONDS_FIELD);
        map.put("FilterConfiguration", FILTER_CONFIGURATION_FIELD);
        map.put("ManifestLayout", MANIFEST_LAYOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMssManifestConfiguration, T> g) {
        return obj -> g.apply((CreateMssManifestConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateMssManifestConfiguration> {
        /**
         * <p>
         * A short string that's appended to the endpoint URL to create a unique path to this MSS manifest. The manifest
         * name must be unique within the origin endpoint and can contain letters, numbers, hyphens, and underscores.
         * </p>
         * 
         * @param manifestName
         *        A short string that's appended to the endpoint URL to create a unique path to this MSS manifest. The
         *        manifest name must be unique within the origin endpoint and can contain letters, numbers, hyphens, and
         *        underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * <p>
         * The total duration (in seconds) of the manifest window. This determines how much content is available in the
         * manifest at any given time. The manifest window slides forward as new segments become available, maintaining
         * a consistent duration of content. The minimum value is 30 seconds.
         * </p>
         * 
         * @param manifestWindowSeconds
         *        The total duration (in seconds) of the manifest window. This determines how much content is available
         *        in the manifest at any given time. The manifest window slides forward as new segments become
         *        available, maintaining a consistent duration of content. The minimum value is 30 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);

        /**
         * Sets the value of the FilterConfiguration property for this object.
         *
         * @param filterConfiguration
         *        The new value for the FilterConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConfiguration(FilterConfiguration filterConfiguration);

        /**
         * Sets the value of the FilterConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FilterConfiguration.Builder} avoiding the
         * need to create one manually via {@link FilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #filterConfiguration(FilterConfiguration)}.
         * 
         * @param filterConfiguration
         *        a consumer that will call methods on {@link FilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterConfiguration(FilterConfiguration)
         */
        default Builder filterConfiguration(Consumer<FilterConfiguration.Builder> filterConfiguration) {
            return filterConfiguration(FilterConfiguration.builder().applyMutation(filterConfiguration).build());
        }

        /**
         * <p>
         * Determines the layout format of the MSS manifest. This controls how the manifest is structured and presented
         * to client players, affecting compatibility with different MSS-compatible devices and applications.
         * </p>
         * 
         * @param manifestLayout
         *        Determines the layout format of the MSS manifest. This controls how the manifest is structured and
         *        presented to client players, affecting compatibility with different MSS-compatible devices and
         *        applications.
         * @see MssManifestLayout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MssManifestLayout
         */
        Builder manifestLayout(String manifestLayout);

        /**
         * <p>
         * Determines the layout format of the MSS manifest. This controls how the manifest is structured and presented
         * to client players, affecting compatibility with different MSS-compatible devices and applications.
         * </p>
         * 
         * @param manifestLayout
         *        Determines the layout format of the MSS manifest. This controls how the manifest is structured and
         *        presented to client players, affecting compatibility with different MSS-compatible devices and
         *        applications.
         * @see MssManifestLayout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MssManifestLayout
         */
        Builder manifestLayout(MssManifestLayout manifestLayout);
    }

    static final class BuilderImpl implements Builder {
        private String manifestName;

        private Integer manifestWindowSeconds;

        private FilterConfiguration filterConfiguration;

        private String manifestLayout;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMssManifestConfiguration model) {
            manifestName(model.manifestName);
            manifestWindowSeconds(model.manifestWindowSeconds);
            filterConfiguration(model.filterConfiguration);
            manifestLayout(model.manifestLayout);
        }

        public final String getManifestName() {
            return manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final FilterConfiguration.Builder getFilterConfiguration() {
            return filterConfiguration != null ? filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(FilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(FilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        public final String getManifestLayout() {
            return manifestLayout;
        }

        public final void setManifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
        }

        @Override
        public final Builder manifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
            return this;
        }

        @Override
        public final Builder manifestLayout(MssManifestLayout manifestLayout) {
            this.manifestLayout(manifestLayout == null ? null : manifestLayout.toString());
            return this;
        }

        @Override
        public CreateMssManifestConfiguration build() {
            return new CreateMssManifestConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
