/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for creating a new harvest job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHarvestJobRequest extends MediaPackageV2Request implements
        ToCopyableBuilder<CreateHarvestJobRequest.Builder, CreateHarvestJobRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelGroupName").getter(getter(CreateHarvestJobRequest::channelGroupName))
            .setter(setter(Builder::channelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(CreateHarvestJobRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginEndpointName").getter(getter(CreateHarvestJobRequest::originEndpointName))
            .setter(setter(Builder::originEndpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OriginEndpointName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateHarvestJobRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<HarvestedManifests> HARVESTED_MANIFESTS_FIELD = SdkField
            .<HarvestedManifests> builder(MarshallingType.SDK_POJO).memberName("HarvestedManifests")
            .getter(getter(CreateHarvestJobRequest::harvestedManifests)).setter(setter(Builder::harvestedManifests))
            .constructor(HarvestedManifests::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HarvestedManifests").build())
            .build();

    private static final SdkField<HarvesterScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<HarvesterScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(CreateHarvestJobRequest::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(HarvesterScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("Destination").getter(getter(CreateHarvestJobRequest::destination)).setter(setter(Builder::destination))
            .constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateHarvestJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-client-token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> HARVEST_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HarvestJobName").getter(getter(CreateHarvestJobRequest::harvestJobName))
            .setter(setter(Builder::harvestJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HarvestJobName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateHarvestJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD,
            CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, DESCRIPTION_FIELD, HARVESTED_MANIFESTS_FIELD,
            SCHEDULE_CONFIGURATION_FIELD, DESTINATION_FIELD, CLIENT_TOKEN_FIELD, HARVEST_JOB_NAME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelGroupName;

    private final String channelName;

    private final String originEndpointName;

    private final String description;

    private final HarvestedManifests harvestedManifests;

    private final HarvesterScheduleConfiguration scheduleConfiguration;

    private final Destination destination;

    private final String clientToken;

    private final String harvestJobName;

    private final Map<String, String> tags;

    private CreateHarvestJobRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.description = builder.description;
        this.harvestedManifests = builder.harvestedManifests;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.destination = builder.destination;
        this.clientToken = builder.clientToken;
        this.harvestJobName = builder.harvestJobName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the channel group containing the channel from which to harvest content.
     * </p>
     * 
     * @return The name of the channel group containing the channel from which to harvest content.
     */
    public final String channelGroupName() {
        return channelGroupName;
    }

    /**
     * <p>
     * The name of the channel from which to harvest content.
     * </p>
     * 
     * @return The name of the channel from which to harvest content.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name of the origin endpoint from which to harvest content.
     * </p>
     * 
     * @return The name of the origin endpoint from which to harvest content.
     */
    public final String originEndpointName() {
        return originEndpointName;
    }

    /**
     * <p>
     * An optional description for the harvest job.
     * </p>
     * 
     * @return An optional description for the harvest job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A list of manifests to be harvested.
     * </p>
     * 
     * @return A list of manifests to be harvested.
     */
    public final HarvestedManifests harvestedManifests() {
        return harvestedManifests;
    }

    /**
     * <p>
     * The configuration for when the harvest job should run, including start and end times.
     * </p>
     * 
     * @return The configuration for when the harvest job should run, including start and end times.
     */
    public final HarvesterScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    /**
     * <p>
     * The S3 destination where the harvested content will be placed.
     * </p>
     * 
     * @return The S3 destination where the harvested content will be placed.
     */
    public final Destination destination() {
        return destination;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A name for the harvest job. This name must be unique within the channel.
     * </p>
     * 
     * @return A name for the harvest job. This name must be unique within the channel.
     */
    public final String harvestJobName() {
        return harvestJobName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of tags associated with the harvest job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of tags associated with the harvest job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(harvestedManifests());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(harvestJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHarvestJobRequest)) {
            return false;
        }
        CreateHarvestJobRequest other = (CreateHarvestJobRequest) obj;
        return Objects.equals(channelGroupName(), other.channelGroupName()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(originEndpointName(), other.originEndpointName())
                && Objects.equals(description(), other.description())
                && Objects.equals(harvestedManifests(), other.harvestedManifests())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration())
                && Objects.equals(destination(), other.destination()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(harvestJobName(), other.harvestJobName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHarvestJobRequest").add("ChannelGroupName", channelGroupName())
                .add("ChannelName", channelName()).add("OriginEndpointName", originEndpointName())
                .add("Description", description()).add("HarvestedManifests", harvestedManifests())
                .add("ScheduleConfiguration", scheduleConfiguration()).add("Destination", destination())
                .add("ClientToken", clientToken()).add("HarvestJobName", harvestJobName()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelGroupName":
            return Optional.ofNullable(clazz.cast(channelGroupName()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "OriginEndpointName":
            return Optional.ofNullable(clazz.cast(originEndpointName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HarvestedManifests":
            return Optional.ofNullable(clazz.cast(harvestedManifests()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "HarvestJobName":
            return Optional.ofNullable(clazz.cast(harvestJobName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("OriginEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("HarvestedManifests", HARVESTED_MANIFESTS_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("x-amzn-client-token", CLIENT_TOKEN_FIELD);
        map.put("HarvestJobName", HARVEST_JOB_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHarvestJobRequest, T> g) {
        return obj -> g.apply((CreateHarvestJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaPackageV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateHarvestJobRequest> {
        /**
         * <p>
         * The name of the channel group containing the channel from which to harvest content.
         * </p>
         * 
         * @param channelGroupName
         *        The name of the channel group containing the channel from which to harvest content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelGroupName(String channelGroupName);

        /**
         * <p>
         * The name of the channel from which to harvest content.
         * </p>
         * 
         * @param channelName
         *        The name of the channel from which to harvest content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name of the origin endpoint from which to harvest content.
         * </p>
         * 
         * @param originEndpointName
         *        The name of the origin endpoint from which to harvest content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originEndpointName(String originEndpointName);

        /**
         * <p>
         * An optional description for the harvest job.
         * </p>
         * 
         * @param description
         *        An optional description for the harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of manifests to be harvested.
         * </p>
         * 
         * @param harvestedManifests
         *        A list of manifests to be harvested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestedManifests(HarvestedManifests harvestedManifests);

        /**
         * <p>
         * A list of manifests to be harvested.
         * </p>
         * This is a convenience method that creates an instance of the {@link HarvestedManifests.Builder} avoiding the
         * need to create one manually via {@link HarvestedManifests#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HarvestedManifests.Builder#build()} is called immediately and its
         * result is passed to {@link #harvestedManifests(HarvestedManifests)}.
         * 
         * @param harvestedManifests
         *        a consumer that will call methods on {@link HarvestedManifests.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #harvestedManifests(HarvestedManifests)
         */
        default Builder harvestedManifests(Consumer<HarvestedManifests.Builder> harvestedManifests) {
            return harvestedManifests(HarvestedManifests.builder().applyMutation(harvestedManifests).build());
        }

        /**
         * <p>
         * The configuration for when the harvest job should run, including start and end times.
         * </p>
         * 
         * @param scheduleConfiguration
         *        The configuration for when the harvest job should run, including start and end times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(HarvesterScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * The configuration for when the harvest job should run, including start and end times.
         * </p>
         * This is a convenience method that creates an instance of the {@link HarvesterScheduleConfiguration.Builder}
         * avoiding the need to create one manually via {@link HarvesterScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HarvesterScheduleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduleConfiguration(HarvesterScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link HarvesterScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(HarvesterScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<HarvesterScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(HarvesterScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }

        /**
         * <p>
         * The S3 destination where the harvested content will be placed.
         * </p>
         * 
         * @param destination
         *        The S3 destination where the harvested content will be placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The S3 destination where the harvested content will be placed.
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A name for the harvest job. This name must be unique within the channel.
         * </p>
         * 
         * @param harvestJobName
         *        A name for the harvest job. This name must be unique within the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder harvestJobName(String harvestJobName);

        /**
         * <p>
         * A collection of tags associated with the harvest job.
         * </p>
         * 
         * @param tags
         *        A collection of tags associated with the harvest job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaPackageV2Request.BuilderImpl implements Builder {
        private String channelGroupName;

        private String channelName;

        private String originEndpointName;

        private String description;

        private HarvestedManifests harvestedManifests;

        private HarvesterScheduleConfiguration scheduleConfiguration;

        private Destination destination;

        private String clientToken;

        private String harvestJobName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHarvestJobRequest model) {
            super(model);
            channelGroupName(model.channelGroupName);
            channelName(model.channelName);
            originEndpointName(model.originEndpointName);
            description(model.description);
            harvestedManifests(model.harvestedManifests);
            scheduleConfiguration(model.scheduleConfiguration);
            destination(model.destination);
            clientToken(model.clientToken);
            harvestJobName(model.harvestJobName);
            tags(model.tags);
        }

        public final String getChannelGroupName() {
            return channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final HarvestedManifests.Builder getHarvestedManifests() {
            return harvestedManifests != null ? harvestedManifests.toBuilder() : null;
        }

        public final void setHarvestedManifests(HarvestedManifests.BuilderImpl harvestedManifests) {
            this.harvestedManifests = harvestedManifests != null ? harvestedManifests.build() : null;
        }

        @Override
        public final Builder harvestedManifests(HarvestedManifests harvestedManifests) {
            this.harvestedManifests = harvestedManifests;
            return this;
        }

        public final HarvesterScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(HarvesterScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(HarvesterScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getHarvestJobName() {
            return harvestJobName;
        }

        public final void setHarvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
        }

        @Override
        public final Builder harvestJobName(String harvestJobName) {
            this.harvestJobName = harvestJobName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHarvestJobRequest build() {
            return new CreateHarvestJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
