/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updating or deleting this resource can cause an inconsistent state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictException extends MediaPackageV2Exception implements
        ToCopyableBuilder<ConflictException.Builder, ConflictException> {
    private static final SdkField<String> CONFLICT_EXCEPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConflictExceptionType").getter(getter(ConflictException::conflictExceptionTypeAsString))
            .setter(setter(Builder::conflictExceptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictExceptionType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONFLICT_EXCEPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conflictExceptionType;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.conflictExceptionType = builder.conflictExceptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The type of ConflictException.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictExceptionType} will return {@link ConflictExceptionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conflictExceptionTypeAsString}.
     * </p>
     * 
     * @return The type of ConflictException.
     * @see ConflictExceptionType
     */
    public ConflictExceptionType conflictExceptionType() {
        return ConflictExceptionType.fromValue(conflictExceptionType);
    }

    /**
     * <p>
     * The type of ConflictException.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conflictExceptionType} will return {@link ConflictExceptionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conflictExceptionTypeAsString}.
     * </p>
     * 
     * @return The type of ConflictException.
     * @see ConflictExceptionType
     */
    public String conflictExceptionTypeAsString() {
        return conflictExceptionType;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConflictExceptionType", CONFLICT_EXCEPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictException>, MediaPackageV2Exception.Builder {
        /**
         * <p>
         * The type of ConflictException.
         * </p>
         * 
         * @param conflictExceptionType
         *        The type of ConflictException.
         * @see ConflictExceptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictExceptionType
         */
        Builder conflictExceptionType(String conflictExceptionType);

        /**
         * <p>
         * The type of ConflictException.
         * </p>
         * 
         * @param conflictExceptionType
         *        The type of ConflictException.
         * @see ConflictExceptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictExceptionType
         */
        Builder conflictExceptionType(ConflictExceptionType conflictExceptionType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends MediaPackageV2Exception.BuilderImpl implements Builder {
        private String conflictExceptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            conflictExceptionType(model.conflictExceptionType);
        }

        public final String getConflictExceptionType() {
            return conflictExceptionType;
        }

        public final void setConflictExceptionType(String conflictExceptionType) {
            this.conflictExceptionType = conflictExceptionType;
        }

        @Override
        public final Builder conflictExceptionType(String conflictExceptionType) {
            this.conflictExceptionType = conflictExceptionType;
            return this;
        }

        @Override
        public final Builder conflictExceptionType(ConflictExceptionType conflictExceptionType) {
            this.conflictExceptionType(conflictExceptionType == null ? null : conflictExceptionType.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
