/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2AsyncClient;
import software.amazon.awssdk.services.mediapackagev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsResponse;
import software.amazon.awssdk.services.mediapackagev2.model.OriginEndpointListConfiguration;

public class ListOriginEndpointsPublisher
implements SdkPublisher<ListOriginEndpointsResponse> {
    private final MediaPackageV2AsyncClient client;
    private final ListOriginEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOriginEndpointsPublisher(MediaPackageV2AsyncClient client, ListOriginEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOriginEndpointsPublisher(MediaPackageV2AsyncClient client, ListOriginEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOriginEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOriginEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OriginEndpointListConfiguration> items() {
        Function<ListOriginEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOriginEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOriginEndpointsResponseFetcher
    implements AsyncPageFetcher<ListOriginEndpointsResponse> {
        private ListOriginEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListOriginEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOriginEndpointsResponse> nextPage(ListOriginEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListOriginEndpointsPublisher.this.client.listOriginEndpoints(ListOriginEndpointsPublisher.this.firstRequest);
            }
            return ListOriginEndpointsPublisher.this.client.listOriginEndpoints((ListOriginEndpointsRequest)((Object)ListOriginEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

