/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagev2.model.ContainerType;
import software.amazon.awssdk.services.mediapackagev2.model.ForceEndpointErrorConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.GetDashManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.GetDashManifestsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.GetHlsManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.GetHlsManifestsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Response;
import software.amazon.awssdk.services.mediapackagev2.model.Segment;
import software.amazon.awssdk.services.mediapackagev2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOriginEndpointResponse
extends MediaPackageV2Response
implements ToCopyableBuilder<Builder, GetOriginEndpointResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::arn)).setter(GetOriginEndpointResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::channelGroupName)).setter(GetOriginEndpointResponse.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::channelName)).setter(GetOriginEndpointResponse.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointName").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::originEndpointName)).setter(GetOriginEndpointResponse.setter(Builder::originEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build()}).build();
    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerType").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::containerTypeAsString)).setter(GetOriginEndpointResponse.setter(Builder::containerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerType").build()}).build();
    private static final SdkField<Segment> SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Segment").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::segment)).setter(GetOriginEndpointResponse.setter(Builder::segment)).constructor(Segment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::createdAt)).setter(GetOriginEndpointResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::modifiedAt)).setter(GetOriginEndpointResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()}).build();
    private static final SdkField<Instant> RESET_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResetAt").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::resetAt)).setter(GetOriginEndpointResponse.setter(Builder::resetAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::description)).setter(GetOriginEndpointResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> STARTOVER_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartoverWindowSeconds").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::startoverWindowSeconds)).setter(GetOriginEndpointResponse.setter(Builder::startoverWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartoverWindowSeconds").build()}).build();
    private static final SdkField<List<GetHlsManifestConfiguration>> HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HlsManifests").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::hlsManifests)).setter(GetOriginEndpointResponse.setter(Builder::hlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetHlsManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetLowLatencyHlsManifestConfiguration>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LowLatencyHlsManifests").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::lowLatencyHlsManifests)).setter(GetOriginEndpointResponse.setter(Builder::lowLatencyHlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetLowLatencyHlsManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetDashManifestConfiguration>> DASH_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashManifests").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::dashManifests)).setter(GetOriginEndpointResponse.setter(Builder::dashManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetDashManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ForceEndpointErrorConfiguration> FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForceEndpointErrorConfiguration").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::forceEndpointErrorConfiguration)).setter(GetOriginEndpointResponse.setter(Builder::forceEndpointErrorConfiguration)).constructor(ForceEndpointErrorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceEndpointErrorConfiguration").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::eTag)).setter(GetOriginEndpointResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetOriginEndpointResponse.getter(GetOriginEndpointResponse::tags)).setter(GetOriginEndpointResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, CONTAINER_TYPE_FIELD, SEGMENT_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, RESET_AT_FIELD, DESCRIPTION_FIELD, STARTOVER_WINDOW_SECONDS_FIELD, HLS_MANIFESTS_FIELD, LOW_LATENCY_HLS_MANIFESTS_FIELD, DASH_MANIFESTS_FIELD, FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD, E_TAG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOriginEndpointResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String channelGroupName;
    private final String channelName;
    private final String originEndpointName;
    private final String containerType;
    private final Segment segment;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final Instant resetAt;
    private final String description;
    private final Integer startoverWindowSeconds;
    private final List<GetHlsManifestConfiguration> hlsManifests;
    private final List<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests;
    private final List<GetDashManifestConfiguration> dashManifests;
    private final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;
    private final String eTag;
    private final Map<String, String> tags;

    private GetOriginEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.containerType = builder.containerType;
        this.segment = builder.segment;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.resetAt = builder.resetAt;
        this.description = builder.description;
        this.startoverWindowSeconds = builder.startoverWindowSeconds;
        this.hlsManifests = builder.hlsManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
        this.dashManifests = builder.dashManifests;
        this.forceEndpointErrorConfiguration = builder.forceEndpointErrorConfiguration;
        this.eTag = builder.eTag;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String originEndpointName() {
        return this.originEndpointName;
    }

    public final ContainerType containerType() {
        return ContainerType.fromValue(this.containerType);
    }

    public final String containerTypeAsString() {
        return this.containerType;
    }

    public final Segment segment() {
        return this.segment;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final Instant resetAt() {
        return this.resetAt;
    }

    public final String description() {
        return this.description;
    }

    public final Integer startoverWindowSeconds() {
        return this.startoverWindowSeconds;
    }

    public final boolean hasHlsManifests() {
        return this.hlsManifests != null && !(this.hlsManifests instanceof SdkAutoConstructList);
    }

    public final List<GetHlsManifestConfiguration> hlsManifests() {
        return this.hlsManifests;
    }

    public final boolean hasLowLatencyHlsManifests() {
        return this.lowLatencyHlsManifests != null && !(this.lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    public final List<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests() {
        return this.lowLatencyHlsManifests;
    }

    public final boolean hasDashManifests() {
        return this.dashManifests != null && !(this.dashManifests instanceof SdkAutoConstructList);
    }

    public final List<GetDashManifestConfiguration> dashManifests() {
        return this.dashManifests;
    }

    public final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration() {
        return this.forceEndpointErrorConfiguration;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.startoverWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHlsManifests() ? this.hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLowLatencyHlsManifests() ? this.lowLatencyHlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashManifests() ? this.dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forceEndpointErrorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOriginEndpointResponse)) {
            return false;
        }
        GetOriginEndpointResponse other = (GetOriginEndpointResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.originEndpointName(), other.originEndpointName()) && Objects.equals(this.containerTypeAsString(), other.containerTypeAsString()) && Objects.equals(this.segment(), other.segment()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.resetAt(), other.resetAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.startoverWindowSeconds(), other.startoverWindowSeconds()) && this.hasHlsManifests() == other.hasHlsManifests() && Objects.equals(this.hlsManifests(), other.hlsManifests()) && this.hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests() && Objects.equals(this.lowLatencyHlsManifests(), other.lowLatencyHlsManifests()) && this.hasDashManifests() == other.hasDashManifests() && Objects.equals(this.dashManifests(), other.dashManifests()) && Objects.equals(this.forceEndpointErrorConfiguration(), other.forceEndpointErrorConfiguration()) && Objects.equals(this.eTag(), other.eTag()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetOriginEndpointResponse").add("Arn", (Object)this.arn()).add("ChannelGroupName", (Object)this.channelGroupName()).add("ChannelName", (Object)this.channelName()).add("OriginEndpointName", (Object)this.originEndpointName()).add("ContainerType", (Object)this.containerTypeAsString()).add("Segment", (Object)this.segment()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("ResetAt", (Object)this.resetAt()).add("Description", (Object)this.description()).add("StartoverWindowSeconds", (Object)this.startoverWindowSeconds()).add("HlsManifests", this.hasHlsManifests() ? this.hlsManifests() : null).add("LowLatencyHlsManifests", this.hasLowLatencyHlsManifests() ? this.lowLatencyHlsManifests() : null).add("DashManifests", this.hasDashManifests() ? this.dashManifests() : null).add("ForceEndpointErrorConfiguration", (Object)this.forceEndpointErrorConfiguration()).add("ETag", (Object)this.eTag()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "OriginEndpointName": {
                return Optional.ofNullable(clazz.cast(this.originEndpointName()));
            }
            case "ContainerType": {
                return Optional.ofNullable(clazz.cast(this.containerTypeAsString()));
            }
            case "Segment": {
                return Optional.ofNullable(clazz.cast(this.segment()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "ResetAt": {
                return Optional.ofNullable(clazz.cast(this.resetAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StartoverWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.startoverWindowSeconds()));
            }
            case "HlsManifests": {
                return Optional.ofNullable(clazz.cast(this.hlsManifests()));
            }
            case "LowLatencyHlsManifests": {
                return Optional.ofNullable(clazz.cast(this.lowLatencyHlsManifests()));
            }
            case "DashManifests": {
                return Optional.ofNullable(clazz.cast(this.dashManifests()));
            }
            case "ForceEndpointErrorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.forceEndpointErrorConfiguration()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("OriginEndpointName", ORIGIN_ENDPOINT_NAME_FIELD);
        map.put("ContainerType", CONTAINER_TYPE_FIELD);
        map.put("Segment", SEGMENT_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ModifiedAt", MODIFIED_AT_FIELD);
        map.put("ResetAt", RESET_AT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("StartoverWindowSeconds", STARTOVER_WINDOW_SECONDS_FIELD);
        map.put("HlsManifests", HLS_MANIFESTS_FIELD);
        map.put("LowLatencyHlsManifests", LOW_LATENCY_HLS_MANIFESTS_FIELD);
        map.put("DashManifests", DASH_MANIFESTS_FIELD);
        map.put("ForceEndpointErrorConfiguration", FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOriginEndpointResponse, T> g) {
        return obj -> g.apply((GetOriginEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Response.BuilderImpl
    implements Builder {
        private String arn;
        private String channelGroupName;
        private String channelName;
        private String originEndpointName;
        private String containerType;
        private Segment segment;
        private Instant createdAt;
        private Instant modifiedAt;
        private Instant resetAt;
        private String description;
        private Integer startoverWindowSeconds;
        private List<GetHlsManifestConfiguration> hlsManifests = DefaultSdkAutoConstructList.getInstance();
        private List<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();
        private List<GetDashManifestConfiguration> dashManifests = DefaultSdkAutoConstructList.getInstance();
        private ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;
        private String eTag;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetOriginEndpointResponse model) {
            super(model);
            this.arn(model.arn);
            this.channelGroupName(model.channelGroupName);
            this.channelName(model.channelName);
            this.originEndpointName(model.originEndpointName);
            this.containerType(model.containerType);
            this.segment(model.segment);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.resetAt(model.resetAt);
            this.description(model.description);
            this.startoverWindowSeconds(model.startoverWindowSeconds);
            this.hlsManifests(model.hlsManifests);
            this.lowLatencyHlsManifests(model.lowLatencyHlsManifests);
            this.dashManifests(model.dashManifests);
            this.forceEndpointErrorConfiguration(model.forceEndpointErrorConfiguration);
            this.eTag(model.eTag);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return this.originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getContainerType() {
            return this.containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final Segment.Builder getSegment() {
            return this.segment != null ? this.segment.toBuilder() : null;
        }

        public final void setSegment(Segment.BuilderImpl segment) {
            this.segment = segment != null ? segment.build() : null;
        }

        @Override
        public final Builder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final Instant getResetAt() {
            return this.resetAt;
        }

        public final void setResetAt(Instant resetAt) {
            this.resetAt = resetAt;
        }

        @Override
        public final Builder resetAt(Instant resetAt) {
            this.resetAt = resetAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getStartoverWindowSeconds() {
            return this.startoverWindowSeconds;
        }

        public final void setStartoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
        }

        @Override
        public final Builder startoverWindowSeconds(Integer startoverWindowSeconds) {
            this.startoverWindowSeconds = startoverWindowSeconds;
            return this;
        }

        public final List<GetHlsManifestConfiguration.Builder> getHlsManifests() {
            List<GetHlsManifestConfiguration.Builder> result = GetHlsManifestsCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<GetHlsManifestConfiguration.BuilderImpl> hlsManifests) {
            this.hlsManifests = GetHlsManifestsCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<GetHlsManifestConfiguration> hlsManifests) {
            this.hlsManifests = GetHlsManifestsCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(GetHlsManifestConfiguration ... hlsManifests) {
            this.hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<GetHlsManifestConfiguration.Builder> ... hlsManifests) {
            this.hlsManifests(Stream.of(hlsManifests).map(c -> (GetHlsManifestConfiguration)((GetHlsManifestConfiguration.Builder)GetHlsManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetLowLatencyHlsManifestConfiguration.Builder> getLowLatencyHlsManifests() {
            List<GetLowLatencyHlsManifestConfiguration.Builder> result = GetLowLatencyHlsManifestsCopier.copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(Collection<GetLowLatencyHlsManifestConfiguration.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = GetLowLatencyHlsManifestsCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<GetLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = GetLowLatencyHlsManifestsCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(GetLowLatencyHlsManifestConfiguration ... lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(Consumer<GetLowLatencyHlsManifestConfiguration.Builder> ... lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests).map(c -> (GetLowLatencyHlsManifestConfiguration)((GetLowLatencyHlsManifestConfiguration.Builder)GetLowLatencyHlsManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetDashManifestConfiguration.Builder> getDashManifests() {
            List<GetDashManifestConfiguration.Builder> result = GetDashManifestsCopier.copyToBuilder(this.dashManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashManifests(Collection<GetDashManifestConfiguration.BuilderImpl> dashManifests) {
            this.dashManifests = GetDashManifestsCopier.copyFromBuilder(dashManifests);
        }

        @Override
        public final Builder dashManifests(Collection<GetDashManifestConfiguration> dashManifests) {
            this.dashManifests = GetDashManifestsCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(GetDashManifestConfiguration ... dashManifests) {
            this.dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<GetDashManifestConfiguration.Builder> ... dashManifests) {
            this.dashManifests(Stream.of(dashManifests).map(c -> (GetDashManifestConfiguration)((GetDashManifestConfiguration.Builder)GetDashManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ForceEndpointErrorConfiguration.Builder getForceEndpointErrorConfiguration() {
            return this.forceEndpointErrorConfiguration != null ? this.forceEndpointErrorConfiguration.toBuilder() : null;
        }

        public final void setForceEndpointErrorConfiguration(ForceEndpointErrorConfiguration.BuilderImpl forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration != null ? forceEndpointErrorConfiguration.build() : null;
        }

        @Override
        public final Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetOriginEndpointResponse build() {
            return new GetOriginEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaPackageV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOriginEndpointResponse> {
        public Builder arn(String var1);

        public Builder channelGroupName(String var1);

        public Builder channelName(String var1);

        public Builder originEndpointName(String var1);

        public Builder containerType(String var1);

        public Builder containerType(ContainerType var1);

        public Builder segment(Segment var1);

        default public Builder segment(Consumer<Segment.Builder> segment) {
            return this.segment((Segment)((Segment.Builder)Segment.builder().applyMutation(segment)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder resetAt(Instant var1);

        public Builder description(String var1);

        public Builder startoverWindowSeconds(Integer var1);

        public Builder hlsManifests(Collection<GetHlsManifestConfiguration> var1);

        public Builder hlsManifests(GetHlsManifestConfiguration ... var1);

        public Builder hlsManifests(Consumer<GetHlsManifestConfiguration.Builder> ... var1);

        public Builder lowLatencyHlsManifests(Collection<GetLowLatencyHlsManifestConfiguration> var1);

        public Builder lowLatencyHlsManifests(GetLowLatencyHlsManifestConfiguration ... var1);

        public Builder lowLatencyHlsManifests(Consumer<GetLowLatencyHlsManifestConfiguration.Builder> ... var1);

        public Builder dashManifests(Collection<GetDashManifestConfiguration> var1);

        public Builder dashManifests(GetDashManifestConfiguration ... var1);

        public Builder dashManifests(Consumer<GetDashManifestConfiguration.Builder> ... var1);

        public Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration var1);

        default public Builder forceEndpointErrorConfiguration(Consumer<ForceEndpointErrorConfiguration.Builder> forceEndpointErrorConfiguration) {
            return this.forceEndpointErrorConfiguration((ForceEndpointErrorConfiguration)((ForceEndpointErrorConfiguration.Builder)ForceEndpointErrorConfiguration.builder().applyMutation(forceEndpointErrorConfiguration)).build());
        }

        public Builder eTag(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

