/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointErrorCondition {
    STALE_MANIFEST("STALE_MANIFEST"),
    INCOMPLETE_MANIFEST("INCOMPLETE_MANIFEST"),
    MISSING_DRM_KEY("MISSING_DRM_KEY"),
    SLATE_INPUT("SLATE_INPUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointErrorCondition> VALUE_MAP;
    private final String value;

    private EndpointErrorCondition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointErrorCondition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointErrorCondition> knownValues() {
        EnumSet<EndpointErrorCondition> knownValues = EnumSet.allOf(EndpointErrorCondition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointErrorCondition.class, EndpointErrorCondition::toString);
    }
}

