/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediapackage.model.AdMarkers;
import software.amazon.awssdk.services.mediapackage.model.AdTriggersCopier;
import software.amazon.awssdk.services.mediapackage.model.AdTriggersElement;
import software.amazon.awssdk.services.mediapackage.model.AdsOnDeliveryRestrictions;
import software.amazon.awssdk.services.mediapackage.model.PlaylistType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsManifestCreateOrUpdateParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsManifestCreateOrUpdateParameters> {
    private static final SdkField<String> AD_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::adMarkersAsString)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::adMarkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build()}).build();
    private static final SdkField<List<String>> AD_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::adTriggersAsStrings)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::adTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADS_ON_DELIVERY_RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::adsOnDeliveryRestrictionsAsString)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::adsOnDeliveryRestrictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adsOnDeliveryRestrictions").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::id)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Boolean> INCLUDE_IFRAME_ONLY_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::includeIframeOnlyStream)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::includeIframeOnlyStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeIframeOnlyStream").build()}).build();
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::manifestName)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()}).build();
    private static final SdkField<String> PLAYLIST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::playlistTypeAsString)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::playlistType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistType").build()}).build();
    private static final SdkField<Integer> PLAYLIST_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::playlistWindowSeconds)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::playlistWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playlistWindowSeconds").build()}).build();
    private static final SdkField<Integer> PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(HlsManifestCreateOrUpdateParameters.getter(HlsManifestCreateOrUpdateParameters::programDateTimeIntervalSeconds)).setter(HlsManifestCreateOrUpdateParameters.setter(Builder::programDateTimeIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimeIntervalSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, AD_TRIGGERS_FIELD, ADS_ON_DELIVERY_RESTRICTIONS_FIELD, ID_FIELD, INCLUDE_IFRAME_ONLY_STREAM_FIELD, MANIFEST_NAME_FIELD, PLAYLIST_TYPE_FIELD, PLAYLIST_WINDOW_SECONDS_FIELD, PROGRAM_DATE_TIME_INTERVAL_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adMarkers;
    private final List<String> adTriggers;
    private final String adsOnDeliveryRestrictions;
    private final String id;
    private final Boolean includeIframeOnlyStream;
    private final String manifestName;
    private final String playlistType;
    private final Integer playlistWindowSeconds;
    private final Integer programDateTimeIntervalSeconds;

    private HlsManifestCreateOrUpdateParameters(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.adTriggers = builder.adTriggers;
        this.adsOnDeliveryRestrictions = builder.adsOnDeliveryRestrictions;
        this.id = builder.id;
        this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
        this.manifestName = builder.manifestName;
        this.playlistType = builder.playlistType;
        this.playlistWindowSeconds = builder.playlistWindowSeconds;
        this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
    }

    public AdMarkers adMarkers() {
        return AdMarkers.fromValue(this.adMarkers);
    }

    public String adMarkersAsString() {
        return this.adMarkers;
    }

    public List<AdTriggersElement> adTriggers() {
        return AdTriggersCopier.copyStringToEnum(this.adTriggers);
    }

    public List<String> adTriggersAsStrings() {
        return this.adTriggers;
    }

    public AdsOnDeliveryRestrictions adsOnDeliveryRestrictions() {
        return AdsOnDeliveryRestrictions.fromValue(this.adsOnDeliveryRestrictions);
    }

    public String adsOnDeliveryRestrictionsAsString() {
        return this.adsOnDeliveryRestrictions;
    }

    public String id() {
        return this.id;
    }

    public Boolean includeIframeOnlyStream() {
        return this.includeIframeOnlyStream;
    }

    public String manifestName() {
        return this.manifestName;
    }

    public PlaylistType playlistType() {
        return PlaylistType.fromValue(this.playlistType);
    }

    public String playlistTypeAsString() {
        return this.playlistType;
    }

    public Integer playlistWindowSeconds() {
        return this.playlistWindowSeconds;
    }

    public Integer programDateTimeIntervalSeconds() {
        return this.programDateTimeIntervalSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.adTriggersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.adsOnDeliveryRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeIframeOnlyStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlistTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlistWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeIntervalSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsManifestCreateOrUpdateParameters)) {
            return false;
        }
        HlsManifestCreateOrUpdateParameters other = (HlsManifestCreateOrUpdateParameters)obj;
        return Objects.equals(this.adMarkersAsString(), other.adMarkersAsString()) && Objects.equals(this.adTriggersAsStrings(), other.adTriggersAsStrings()) && Objects.equals(this.adsOnDeliveryRestrictionsAsString(), other.adsOnDeliveryRestrictionsAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.includeIframeOnlyStream(), other.includeIframeOnlyStream()) && Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.playlistTypeAsString(), other.playlistTypeAsString()) && Objects.equals(this.playlistWindowSeconds(), other.playlistWindowSeconds()) && Objects.equals(this.programDateTimeIntervalSeconds(), other.programDateTimeIntervalSeconds());
    }

    public String toString() {
        return ToString.builder((String)"HlsManifestCreateOrUpdateParameters").add("AdMarkers", (Object)this.adMarkersAsString()).add("AdTriggers", this.adTriggersAsStrings()).add("AdsOnDeliveryRestrictions", (Object)this.adsOnDeliveryRestrictionsAsString()).add("Id", (Object)this.id()).add("IncludeIframeOnlyStream", (Object)this.includeIframeOnlyStream()).add("ManifestName", (Object)this.manifestName()).add("PlaylistType", (Object)this.playlistTypeAsString()).add("PlaylistWindowSeconds", (Object)this.playlistWindowSeconds()).add("ProgramDateTimeIntervalSeconds", (Object)this.programDateTimeIntervalSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.ofNullable(clazz.cast(this.adMarkersAsString()));
            }
            case "AdTriggers": {
                return Optional.ofNullable(clazz.cast(this.adTriggersAsStrings()));
            }
            case "AdsOnDeliveryRestrictions": {
                return Optional.ofNullable(clazz.cast(this.adsOnDeliveryRestrictionsAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IncludeIframeOnlyStream": {
                return Optional.ofNullable(clazz.cast(this.includeIframeOnlyStream()));
            }
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "PlaylistType": {
                return Optional.ofNullable(clazz.cast(this.playlistTypeAsString()));
            }
            case "PlaylistWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.playlistWindowSeconds()));
            }
            case "ProgramDateTimeIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.programDateTimeIntervalSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsManifestCreateOrUpdateParameters, T> g) {
        return obj -> g.apply((HlsManifestCreateOrUpdateParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adMarkers;
        private List<String> adTriggers = DefaultSdkAutoConstructList.getInstance();
        private String adsOnDeliveryRestrictions;
        private String id;
        private Boolean includeIframeOnlyStream;
        private String manifestName;
        private String playlistType;
        private Integer playlistWindowSeconds;
        private Integer programDateTimeIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsManifestCreateOrUpdateParameters model) {
            this.adMarkers(model.adMarkers);
            this.adTriggersWithStrings(model.adTriggers);
            this.adsOnDeliveryRestrictions(model.adsOnDeliveryRestrictions);
            this.id(model.id);
            this.includeIframeOnlyStream(model.includeIframeOnlyStream);
            this.manifestName(model.manifestName);
            this.playlistType(model.playlistType);
            this.playlistWindowSeconds(model.playlistWindowSeconds);
            this.programDateTimeIntervalSeconds(model.programDateTimeIntervalSeconds);
        }

        public final String getAdMarkersAsString() {
            return this.adMarkers;
        }

        @Override
        public final Builder adMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
            return this;
        }

        @Override
        public final Builder adMarkers(AdMarkers adMarkers) {
            this.adMarkers(adMarkers.toString());
            return this;
        }

        public final void setAdMarkers(String adMarkers) {
            this.adMarkers = adMarkers;
        }

        public final Collection<String> getAdTriggersAsStrings() {
            return this.adTriggers;
        }

        @Override
        public final Builder adTriggersWithStrings(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adTriggersWithStrings(String ... adTriggers) {
            this.adTriggersWithStrings(Arrays.asList(adTriggers));
            return this;
        }

        @Override
        public final Builder adTriggers(Collection<AdTriggersElement> adTriggers) {
            this.adTriggers = AdTriggersCopier.copyEnumToString(adTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adTriggers(AdTriggersElement ... adTriggers) {
            this.adTriggers(Arrays.asList(adTriggers));
            return this;
        }

        public final void setAdTriggersWithStrings(Collection<String> adTriggers) {
            this.adTriggers = AdTriggersCopier.copy(adTriggers);
        }

        public final String getAdsOnDeliveryRestrictionsAsString() {
            return this.adsOnDeliveryRestrictions;
        }

        @Override
        public final Builder adsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
            return this;
        }

        @Override
        public final Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions(adsOnDeliveryRestrictions.toString());
            return this;
        }

        public final void setAdsOnDeliveryRestrictions(String adsOnDeliveryRestrictions) {
            this.adsOnDeliveryRestrictions = adsOnDeliveryRestrictions;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIncludeIframeOnlyStream() {
            return this.includeIframeOnlyStream;
        }

        @Override
        public final Builder includeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
            return this;
        }

        public final void setIncludeIframeOnlyStream(Boolean includeIframeOnlyStream) {
            this.includeIframeOnlyStream = includeIframeOnlyStream;
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        public final String getPlaylistTypeAsString() {
            return this.playlistType;
        }

        @Override
        public final Builder playlistType(String playlistType) {
            this.playlistType = playlistType;
            return this;
        }

        @Override
        public final Builder playlistType(PlaylistType playlistType) {
            this.playlistType(playlistType.toString());
            return this;
        }

        public final void setPlaylistType(String playlistType) {
            this.playlistType = playlistType;
        }

        public final Integer getPlaylistWindowSeconds() {
            return this.playlistWindowSeconds;
        }

        @Override
        public final Builder playlistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
            return this;
        }

        public final void setPlaylistWindowSeconds(Integer playlistWindowSeconds) {
            this.playlistWindowSeconds = playlistWindowSeconds;
        }

        public final Integer getProgramDateTimeIntervalSeconds() {
            return this.programDateTimeIntervalSeconds;
        }

        @Override
        public final Builder programDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
            return this;
        }

        public final void setProgramDateTimeIntervalSeconds(Integer programDateTimeIntervalSeconds) {
            this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
        }

        public HlsManifestCreateOrUpdateParameters build() {
            return new HlsManifestCreateOrUpdateParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsManifestCreateOrUpdateParameters> {
        public Builder adMarkers(String var1);

        public Builder adMarkers(AdMarkers var1);

        public Builder adTriggersWithStrings(Collection<String> var1);

        public Builder adTriggersWithStrings(String ... var1);

        public Builder adTriggers(Collection<AdTriggersElement> var1);

        public Builder adTriggers(AdTriggersElement ... var1);

        public Builder adsOnDeliveryRestrictions(String var1);

        public Builder adsOnDeliveryRestrictions(AdsOnDeliveryRestrictions var1);

        public Builder id(String var1);

        public Builder includeIframeOnlyStream(Boolean var1);

        public Builder manifestName(String var1);

        public Builder playlistType(String var1);

        public Builder playlistType(PlaylistType var1);

        public Builder playlistWindowSeconds(Integer var1);

        public Builder programDateTimeIntervalSeconds(Integer var1);
    }
}

