/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediapackage.DefaultMediaPackageAsyncClient;
import software.amazon.awssdk.services.mediapackage.DefaultMediaPackageBaseClientBuilder;
import software.amazon.awssdk.services.mediapackage.MediaPackageAsyncClient;
import software.amazon.awssdk.services.mediapackage.MediaPackageAsyncClientBuilder;
import software.amazon.awssdk.services.mediapackage.MediaPackageServiceClientConfiguration;
import software.amazon.awssdk.services.mediapackage.endpoints.MediaPackageEndpointProvider;

@SdkInternalApi
final class DefaultMediaPackageAsyncClientBuilder
extends DefaultMediaPackageBaseClientBuilder<MediaPackageAsyncClientBuilder, MediaPackageAsyncClient>
implements MediaPackageAsyncClientBuilder {
    DefaultMediaPackageAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaPackageAsyncClientBuilder endpointProvider(MediaPackageEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaPackageAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaPackageAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MediaPackageServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaPackageAsyncClient client = new DefaultMediaPackageAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaPackageServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaPackageServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

