/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediapackage.DefaultMediaPackageBaseClientBuilder;
import software.amazon.awssdk.services.mediapackage.DefaultMediaPackageClient;
import software.amazon.awssdk.services.mediapackage.MediaPackageClient;
import software.amazon.awssdk.services.mediapackage.MediaPackageClientBuilder;
import software.amazon.awssdk.services.mediapackage.MediaPackageServiceClientConfiguration;
import software.amazon.awssdk.services.mediapackage.endpoints.MediaPackageEndpointProvider;

@SdkInternalApi
final class DefaultMediaPackageClientBuilder
extends DefaultMediaPackageBaseClientBuilder<MediaPackageClientBuilder, MediaPackageClient>
implements MediaPackageClientBuilder {
    DefaultMediaPackageClientBuilder() {
    }

    @Override
    public DefaultMediaPackageClientBuilder endpointProvider(MediaPackageEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaPackageClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaPackageClientBuilder.validateClientOptions(clientConfiguration);
        MediaPackageServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaPackageClient client = new DefaultMediaPackageClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaPackageServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaPackageServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

