/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageRequest;
import software.amazon.awssdk.services.mediapackage.model.S3Destination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHarvestJobRequest
extends MediaPackageRequest
implements ToCopyableBuilder<Builder, CreateHarvestJobRequest> {
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTime").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::endTime)).setter(CreateHarvestJobRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::id)).setter(CreateHarvestJobRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointId").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::originEndpointId)).setter(CreateHarvestJobRequest.setter(Builder::originEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originEndpointId").build()}).build();
    private static final SdkField<S3Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Destination").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::s3Destination)).setter(CreateHarvestJobRequest.setter(Builder::s3Destination)).constructor(S3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(CreateHarvestJobRequest.getter(CreateHarvestJobRequest::startTime)).setter(CreateHarvestJobRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, ID_FIELD, ORIGIN_ENDPOINT_ID_FIELD, S3_DESTINATION_FIELD, START_TIME_FIELD));
    private final String endTime;
    private final String id;
    private final String originEndpointId;
    private final S3Destination s3Destination;
    private final String startTime;

    private CreateHarvestJobRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.id = builder.id;
        this.originEndpointId = builder.originEndpointId;
        this.s3Destination = builder.s3Destination;
        this.startTime = builder.startTime;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final String id() {
        return this.id;
    }

    public final String originEndpointId() {
        return this.originEndpointId;
    }

    public final S3Destination s3Destination() {
        return this.s3Destination;
    }

    public final String startTime() {
        return this.startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHarvestJobRequest)) {
            return false;
        }
        CreateHarvestJobRequest other = (CreateHarvestJobRequest)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.originEndpointId(), other.originEndpointId()) && Objects.equals(this.s3Destination(), other.s3Destination()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHarvestJobRequest").add("EndTime", (Object)this.endTime()).add("Id", (Object)this.id()).add("OriginEndpointId", (Object)this.originEndpointId()).add("S3Destination", (Object)this.s3Destination()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OriginEndpointId": {
                return Optional.ofNullable(clazz.cast(this.originEndpointId()));
            }
            case "S3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHarvestJobRequest, T> g) {
        return obj -> g.apply((CreateHarvestJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageRequest.BuilderImpl
    implements Builder {
        private String endTime;
        private String id;
        private String originEndpointId;
        private S3Destination s3Destination;
        private String startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHarvestJobRequest model) {
            super(model);
            this.endTime(model.endTime);
            this.id(model.id);
            this.originEndpointId(model.originEndpointId);
            this.s3Destination(model.s3Destination);
            this.startTime(model.startTime);
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOriginEndpointId() {
            return this.originEndpointId;
        }

        public final void setOriginEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
        }

        @Override
        @Transient
        public final Builder originEndpointId(String originEndpointId) {
            this.originEndpointId = originEndpointId;
            return this;
        }

        public final S3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Destination(S3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHarvestJobRequest build() {
            return new CreateHarvestJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHarvestJobRequest> {
        public Builder endTime(String var1);

        public Builder id(String var1);

        public Builder originEndpointId(String var1);

        public Builder s3Destination(S3Destination var1);

        default public Builder s3Destination(Consumer<S3Destination.Builder> s3Destination) {
            return this.s3Destination((S3Destination)((S3Destination.Builder)S3Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder startTime(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

