/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackage.model.CmafEncryption;
import software.amazon.awssdk.services.mediapackage.model.HlsManifestCreateOrUpdateParameters;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;
import software.amazon.awssdk.services.mediapackage.model.___listOfHlsManifestCreateOrUpdateParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafPackageCreateOrUpdateParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafPackageCreateOrUpdateParameters> {
    private static final SdkField<CmafEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CmafPackageCreateOrUpdateParameters.getter(CmafPackageCreateOrUpdateParameters::encryption)).setter(CmafPackageCreateOrUpdateParameters.setter(Builder::encryption)).constructor(CmafEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<List<HlsManifestCreateOrUpdateParameters>> HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CmafPackageCreateOrUpdateParameters.getter(CmafPackageCreateOrUpdateParameters::hlsManifests)).setter(CmafPackageCreateOrUpdateParameters.setter(Builder::hlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HlsManifestCreateOrUpdateParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CmafPackageCreateOrUpdateParameters.getter(CmafPackageCreateOrUpdateParameters::segmentDurationSeconds)).setter(CmafPackageCreateOrUpdateParameters.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final SdkField<String> SEGMENT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafPackageCreateOrUpdateParameters.getter(CmafPackageCreateOrUpdateParameters::segmentPrefix)).setter(CmafPackageCreateOrUpdateParameters.setter(Builder::segmentPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentPrefix").build()}).build();
    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CmafPackageCreateOrUpdateParameters.getter(CmafPackageCreateOrUpdateParameters::streamSelection)).setter(CmafPackageCreateOrUpdateParameters.setter(Builder::streamSelection)).constructor(StreamSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD, HLS_MANIFESTS_FIELD, SEGMENT_DURATION_SECONDS_FIELD, SEGMENT_PREFIX_FIELD, STREAM_SELECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final CmafEncryption encryption;
    private final List<HlsManifestCreateOrUpdateParameters> hlsManifests;
    private final Integer segmentDurationSeconds;
    private final String segmentPrefix;
    private final StreamSelection streamSelection;

    private CmafPackageCreateOrUpdateParameters(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.hlsManifests = builder.hlsManifests;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.segmentPrefix = builder.segmentPrefix;
        this.streamSelection = builder.streamSelection;
    }

    public CmafEncryption encryption() {
        return this.encryption;
    }

    public boolean hasHlsManifests() {
        return this.hlsManifests != null && !(this.hlsManifests instanceof SdkAutoConstructList);
    }

    public List<HlsManifestCreateOrUpdateParameters> hlsManifests() {
        return this.hlsManifests;
    }

    public Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public String segmentPrefix() {
        return this.segmentPrefix;
    }

    public StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsManifests());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafPackageCreateOrUpdateParameters)) {
            return false;
        }
        CmafPackageCreateOrUpdateParameters other = (CmafPackageCreateOrUpdateParameters)obj;
        return Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.hlsManifests(), other.hlsManifests()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.segmentPrefix(), other.segmentPrefix()) && Objects.equals(this.streamSelection(), other.streamSelection());
    }

    public String toString() {
        return ToString.builder((String)"CmafPackageCreateOrUpdateParameters").add("Encryption", (Object)this.encryption()).add("HlsManifests", this.hlsManifests()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("SegmentPrefix", (Object)this.segmentPrefix()).add("StreamSelection", (Object)this.streamSelection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "HlsManifests": {
                return Optional.ofNullable(clazz.cast(this.hlsManifests()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
            case "SegmentPrefix": {
                return Optional.ofNullable(clazz.cast(this.segmentPrefix()));
            }
            case "StreamSelection": {
                return Optional.ofNullable(clazz.cast(this.streamSelection()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafPackageCreateOrUpdateParameters, T> g) {
        return obj -> g.apply((CmafPackageCreateOrUpdateParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CmafEncryption encryption;
        private List<HlsManifestCreateOrUpdateParameters> hlsManifests = DefaultSdkAutoConstructList.getInstance();
        private Integer segmentDurationSeconds;
        private String segmentPrefix;
        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafPackageCreateOrUpdateParameters model) {
            this.encryption(model.encryption);
            this.hlsManifests(model.hlsManifests);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.segmentPrefix(model.segmentPrefix);
            this.streamSelection(model.streamSelection);
        }

        public final CmafEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(CmafEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(CmafEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Collection<HlsManifestCreateOrUpdateParameters.Builder> getHlsManifests() {
            return this.hlsManifests != null ? (Collection)this.hlsManifests.stream().map(HlsManifestCreateOrUpdateParameters::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hlsManifests(Collection<HlsManifestCreateOrUpdateParameters> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCreateOrUpdateParametersCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(HlsManifestCreateOrUpdateParameters ... hlsManifests) {
            this.hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<HlsManifestCreateOrUpdateParameters.Builder> ... hlsManifests) {
            this.hlsManifests(Stream.of(hlsManifests).map(c -> (HlsManifestCreateOrUpdateParameters)((HlsManifestCreateOrUpdateParameters.Builder)HlsManifestCreateOrUpdateParameters.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHlsManifests(Collection<HlsManifestCreateOrUpdateParameters.BuilderImpl> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCreateOrUpdateParametersCopier.copyFromBuilder(hlsManifests);
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final String getSegmentPrefix() {
            return this.segmentPrefix;
        }

        @Override
        public final Builder segmentPrefix(String segmentPrefix) {
            this.segmentPrefix = segmentPrefix;
            return this;
        }

        public final void setSegmentPrefix(String segmentPrefix) {
            this.segmentPrefix = segmentPrefix;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public CmafPackageCreateOrUpdateParameters build() {
            return new CmafPackageCreateOrUpdateParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafPackageCreateOrUpdateParameters> {
        public Builder encryption(CmafEncryption var1);

        default public Builder encryption(Consumer<CmafEncryption.Builder> encryption) {
            return this.encryption((CmafEncryption)((CmafEncryption.Builder)CmafEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder hlsManifests(Collection<HlsManifestCreateOrUpdateParameters> var1);

        public Builder hlsManifests(HlsManifestCreateOrUpdateParameters ... var1);

        public Builder hlsManifests(Consumer<HlsManifestCreateOrUpdateParameters.Builder> ... var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder segmentPrefix(String var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().applyMutation(streamSelection)).build());
        }
    }
}

