/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;

@SdkInternalApi
public class StreamSelectionMarshaller {
    private static final MarshallingInfo<Integer> MAXVIDEOBITSPERSECOND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxVideoBitsPerSecond").build();
    private static final MarshallingInfo<Integer> MINVIDEOBITSPERSECOND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minVideoBitsPerSecond").build();
    private static final MarshallingInfo<String> STREAMORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamOrder").build();
    private static final StreamSelectionMarshaller INSTANCE = new StreamSelectionMarshaller();

    public static StreamSelectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamSelection streamSelection, ProtocolMarshaller protocolMarshaller) {
        if (streamSelection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)streamSelection.maxVideoBitsPerSecond(), MAXVIDEOBITSPERSECOND_BINDING);
            protocolMarshaller.marshall((Object)streamSelection.minVideoBitsPerSecond(), MINVIDEOBITSPERSECOND_BINDING);
            protocolMarshaller.marshall((Object)streamSelection.streamOrderString(), STREAMORDER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

