/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediapackage.model.MssPackage;
import software.amazon.awssdk.services.mediapackage.transform.MssEncryptionUnmarshaller;
import software.amazon.awssdk.services.mediapackage.transform.StreamSelectionUnmarshaller;

public class MssPackageUnmarshaller
implements Unmarshaller<MssPackage, JsonUnmarshallerContext> {
    private static final MssPackageUnmarshaller INSTANCE = new MssPackageUnmarshaller();

    public MssPackage unmarshall(JsonUnmarshallerContext context) throws Exception {
        MssPackage.Builder mssPackageBuilder = MssPackage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("encryption", targetDepth)) {
                    context.nextToken();
                    mssPackageBuilder.encryption(MssEncryptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("manifestWindowSeconds", targetDepth)) {
                    context.nextToken();
                    mssPackageBuilder.manifestWindowSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("segmentDurationSeconds", targetDepth)) {
                    context.nextToken();
                    mssPackageBuilder.segmentDurationSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("streamSelection", targetDepth)) {
                    context.nextToken();
                    mssPackageBuilder.streamSelection(StreamSelectionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (MssPackage)mssPackageBuilder.build();
    }

    public static MssPackageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

