/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.mediapackage.MediaPackageClient;
import software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest;
import software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsResponse;
import software.amazon.awssdk.services.mediapackage.model.OriginEndpoint;

public final class ListOriginEndpointsPaginator
implements SdkIterable<ListOriginEndpointsResponse> {
    private final MediaPackageClient client;
    private final ListOriginEndpointsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListOriginEndpointsPaginator(MediaPackageClient client, ListOriginEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOriginEndpointsResponseFetcher();
    }

    public Iterator<ListOriginEndpointsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<OriginEndpoint> originEndpoints() {
        Function<ListOriginEndpointsResponse, Iterator> getIterator = response -> response != null ? response.originEndpoints().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListOriginEndpointsResponseFetcher
    implements NextPageFetcher<ListOriginEndpointsResponse> {
        private ListOriginEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListOriginEndpointsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListOriginEndpointsResponse nextPage(ListOriginEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListOriginEndpointsPaginator.this.client.listOriginEndpoints(ListOriginEndpointsPaginator.this.firstRequest);
            }
            return ListOriginEndpointsPaginator.this.client.listOriginEndpoints((ListOriginEndpointsRequest)((Object)ListOriginEndpointsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

